/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.recipe.ingredients;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class SeedIngredient
extends Ingredient {
    public static final SeedIngredient INSTANCE = new SeedIngredient();
    private static final Pattern SEED_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)seed)|(?:(?:[a-z-_.:]|^)Seed))(?:[sA-Z-_.:]|$)");
    private static Ingredient SEEDS = null;

    public SeedIngredient() {
        super(Stream.empty());
    }

    public boolean isSimple() {
        return false;
    }

    public ItemStack[] func_193365_a() {
        return SeedIngredient.get().func_193365_a();
    }

    public IntList func_194139_b() {
        return SeedIngredient.get().func_194139_b();
    }

    public boolean func_203189_d() {
        return SeedIngredient.get().func_203189_d();
    }

    protected void invalidate() {
        super.invalidate();
        SEEDS = null;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        return obj;
    }

    public boolean test(@Nullable ItemStack p_test_1_) {
        return SeedIngredient.get().test(p_test_1_);
    }

    private static Ingredient get() {
        if (SEEDS == null) {
            NonNullList matchingStacks = NonNullList.func_191196_a();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                Block block;
                if (!SEED_PATTERN.matcher(item.func_77658_a()).find() || item == Items.field_151075_bm || !(item instanceof BlockItem) || !((block = ((BlockItem)item).func_179223_d()) instanceof IPlantable)) continue;
                matchingStacks.add((Object)new ItemStack((IItemProvider)item));
            }
            SEEDS = Ingredient.func_193369_a((ItemStack[])((ItemStack[])matchingStacks.toArray((Object[])new ItemStack[0])));
        }
        return SEEDS;
    }

    public static class Serializer
    implements IIngredientSerializer<SeedIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        private static final short ID = 291;

        public SeedIngredient parse(PacketBuffer buffer) {
            return INSTANCE;
        }

        public SeedIngredient parse(JsonObject json) {
            return INSTANCE;
        }

        public void write(PacketBuffer buffer, SeedIngredient ingredient) {
        }
    }
}

