/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.repack.registrate.util;

import com.google.common.collect.ObjectArrays;
import com.google.gson.JsonElement;
import epicsquid.mysticalworld.repack.registrate.providers.RegistrateRecipeProvider;
import epicsquid.mysticalworld.repack.registrate.util.nullness.NonNullSupplier;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class DataIngredient
extends Ingredient {
    private final Ingredient parent;
    private final ResourceLocation id;
    private final Function<RegistrateRecipeProvider, InventoryChangeTrigger.Instance> criteriaFactory;

    private DataIngredient(Ingredient parent, IItemProvider item) {
        super(Stream.empty());
        this.parent = parent;
        this.id = item.func_199767_j().getRegistryName();
        this.criteriaFactory = prov -> RegistrateRecipeProvider.hasItem(item);
    }

    private DataIngredient(Ingredient parent, ITag.INamedTag<Item> tag) {
        super(Stream.empty());
        this.parent = parent;
        this.id = tag.func_230234_a_();
        this.criteriaFactory = prov -> RegistrateRecipeProvider.hasItem((ITag<Item>)tag);
    }

    private DataIngredient(Ingredient parent, ResourceLocation id, ItemPredicate ... predicates) {
        super(Stream.empty());
        this.parent = parent;
        this.id = id;
        this.criteriaFactory = prov -> RegistrateRecipeProvider.hasItem(predicates);
    }

    public IIngredientSerializer<DataIngredient> getSerializer() {
        throw new UnsupportedOperationException("DataIngredient should only be used for data generation!");
    }

    public InventoryChangeTrigger.Instance getCritereon(RegistrateRecipeProvider prov) {
        return this.criteriaFactory.apply(prov);
    }

    @SafeVarargs
    public static <T extends IItemProvider & IForgeRegistryEntry<?>> DataIngredient items(NonNullSupplier<? extends T> first, NonNullSupplier<? extends T> ... others) {
        return DataIngredient.items((IItemProvider)((IItemProvider)first.get()), (IItemProvider[])((IItemProvider[])Arrays.stream(others).map(Supplier::get).toArray(IItemProvider[]::new)));
    }

    @SafeVarargs
    public static <T extends IItemProvider & IForgeRegistryEntry<?>> DataIngredient items(T first, T ... others) {
        return DataIngredient.ingredient(Ingredient.func_199804_a((IItemProvider[])((IItemProvider[])ObjectArrays.concat(first, (Object[])others))), first);
    }

    public static DataIngredient stacks(ItemStack first, ItemStack ... others) {
        return DataIngredient.ingredient(Ingredient.func_193369_a((ItemStack[])((ItemStack[])ObjectArrays.concat((Object)first, (Object[])others))), (IItemProvider)first.func_77973_b());
    }

    public static DataIngredient tag(ITag.INamedTag<Item> tag) {
        return DataIngredient.ingredient(Ingredient.func_199805_a(tag), tag);
    }

    public static DataIngredient ingredient(Ingredient parent, IItemProvider required) {
        return new DataIngredient(parent, required);
    }

    public static DataIngredient ingredient(Ingredient parent, ITag.INamedTag<Item> required) {
        return new DataIngredient(parent, required);
    }

    public static DataIngredient ingredient(Ingredient parent, ResourceLocation id, ItemPredicate ... criteria) {
        return new DataIngredient(parent, id, criteria);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ItemStack[] func_193365_a() {
        return this.parent.func_193365_a();
    }

    public boolean test(ItemStack arg0) {
        return this.parent.test(arg0);
    }

    public IntList func_194139_b() {
        return this.parent.func_194139_b();
    }

    public JsonElement func_200304_c() {
        return this.parent.func_200304_c();
    }

    public boolean func_203189_d() {
        return this.parent.func_203189_d();
    }

    public boolean isSimple() {
        return this.parent.isSimple();
    }

    public Predicate<ItemStack> and(Predicate<? super ItemStack> arg0) {
        return this.parent.and(arg0);
    }

    public Predicate<ItemStack> negate() {
        return this.parent.negate();
    }

    public Predicate<ItemStack> or(Predicate<? super ItemStack> arg0) {
        return this.parent.or(arg0);
    }

    private static interface Excludes {
        public IIngredientSerializer<DataIngredient> getSerializer();

        public void write(PacketBuffer var1);

        public boolean isVanilla();
    }
}

