/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.libs.repack_mysticalworld.noobutil.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CycleTimer {
    private static final int cycleTime = 1000;
    private long startTime;
    private long drawTime;
    private long pausedDuration = 0L;

    public CycleTimer(int offset) {
        if (offset == -1) {
            offset = (int)(Math.random() * 10000.0);
        }
        long time = System.currentTimeMillis();
        this.startTime = time - (long)(offset * 1000);
        this.drawTime = time;
    }

    @Nullable
    public <T> T getCycledItem(Collection<T> list) {
        return this.getCycledItem((List<T>)new ArrayList<T>(list));
    }

    @Nullable
    public <T> T getCycledItem(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        Long index = (this.drawTime - this.startTime) / 1000L % (long)list.size();
        return list.get(index.intValue());
    }

    public void onDraw() {
        if (!Screen.func_231173_s_()) {
            if (this.pausedDuration > 0L) {
                this.startTime += this.pausedDuration;
                this.pausedDuration = 0L;
            }
            this.drawTime = System.currentTimeMillis();
        } else {
            this.pausedDuration = System.currentTimeMillis() - this.drawTime;
        }
    }
}

