/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.libs.repack_mysticalworld.noobutil.config;

import java.util.Collection;
import net.minecraftforge.common.ForgeConfigSpec;

public class BiomeConfig {
    private String name;
    private double weight;
    private ForgeConfigSpec.DoubleValue configWeight;

    private BiomeConfig(String name, double weight, Collection<BiomeConfig> list) {
        this.name = name;
        this.weight = weight;
        list.add(this);
    }

    private BiomeConfig(String name, int weight, Collection<BiomeConfig> list) {
        this(name, (double)weight, list);
    }

    public String name() {
        return this.name;
    }

    public double weight() {
        return (Double)this.configWeight.get();
    }

    public boolean shouldSpawn() {
        return this.weight() > 0.0;
    }

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.comment(this.name + " biome generation").push(this.name + "_biome");
        this.configWeight = builder.comment("spawn weight of the biome (0 to disable generation)").defineInRange("weight", this.weight, 0.0, Double.MAX_VALUE);
        builder.pop();
    }

    public static class Builder {
        private final Collection<BiomeConfig> list;

        public Builder(Collection<BiomeConfig> list) {
            this.list = list;
        }

        public BiomeConfig build(String name, int weight) {
            return new BiomeConfig(name, weight, (Collection)this.list);
        }

        public BiomeConfig build(String name, double weight) {
            return new BiomeConfig(name, weight, this.list);
        }
    }
}

