/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.libs.repack_mysticalworld.noobutil.modifiers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import noobanidus.libs.repack_mysticalworld.noobutil.NoobUtil;

public class PlayerModifierRegistry {
    private static boolean activated = false;
    private static final Set<Supplier<? extends Attribute>> attributes = new HashSet<Supplier<? extends Attribute>>();

    public static void addModifier(Supplier<? extends Attribute> modifier) {
        if (activated) {
            NoobUtil.logger.error("Attempted to add a new Player modifier after modifiers have already been added.");
        } else {
            attributes.add(modifier);
        }
    }

    public static void init() {
        if (attributes.isEmpty() || activated) {
            return;
        }
        AttributeModifierMap player = GlobalEntityTypeAttributes.func_233835_a_((EntityType)EntityType.field_200729_aH);
        HashMap<Attribute, ModifiableAttributeInstance> map = new HashMap<Attribute, ModifiableAttributeInstance>(player.field_233802_a_);
        for (Supplier<? extends Attribute> modifier : attributes) {
            Attribute attr = modifier.get();
            map.put(attr, new ModifiableAttributeInstance(attr, instance -> {}));
        }
        player.field_233802_a_ = map;
        NoobUtil.logger.info("Added " + attributes.size() + " additional attributes to PlayerEntity.");
        activated = true;
    }
}

