/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.libs.repack_mysticalworld.noobutil.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import noobanidus.libs.repack_mysticalworld.noobutil.types.LazySupplier;

public class LazyStateSupplier
extends LazySupplier<BlockState> {
    public static Codec<LazyStateSupplier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.fieldOf("location").forGetter(o -> o.location), (App)BlockState.field_235877_b_.optionalFieldOf("state").forGetter(o -> o.state)).apply((Applicative)instance, (loc, state) -> state.map(LazyStateSupplier::new).orElseGet(() -> new LazyStateSupplier((ResourceLocation)loc))));
    private final ResourceLocation location;
    private final Optional<BlockState> state;

    public LazyStateSupplier(String namespace, String name) {
        this(new ResourceLocation(namespace, name));
    }

    public LazyStateSupplier(ResourceLocation location) {
        this.supplier = () -> {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
            if (block != null) {
                return block.func_176223_P();
            }
            return Blocks.field_150350_a.func_176223_P();
        };
        this.location = location;
        this.state = Optional.empty();
    }

    public LazyStateSupplier(BlockState stateIn) {
        this.state = Optional.of(stateIn);
        this.supplier = () -> this.state.orElse(Blocks.field_150350_a.func_176223_P());
        this.location = stateIn.func_177230_c().getRegistryName();
    }
}

