/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.libs.repack_mysticalworld.noobutil.world.gen;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import noobanidus.libs.repack_mysticalworld.noobutil.world.gen.ColorConstants;

public final class BiomeBuilder
implements Cloneable {
    public static final BiomeTemplate BIOME_TEMPLATE = new BiomeTemplate(BiomeBuilder.create());
    private ConfiguredSurfaceBuilder<?> surfaceBuilder;
    private Biome.RainType precipitation;
    private Biome.Category category;
    private BiomeAmbience.Builder effects;
    private Biome.TemperatureModifier temperatureModifier;
    private Float depth;
    private Float scale;
    private Float temperature;
    private Float downfall;
    private final ArrayList<Consumer<BiomeGenerationSettings.Builder>> defaultFeatureFunctions = new ArrayList();
    private final ArrayList<Pair<GenerationStage.Decoration, ConfiguredFeature<?, ?>>> features = new ArrayList();
    private final ArrayList<StructureFeature<? extends IFeatureConfig, ? extends Structure<? extends IFeatureConfig>>> structureFeatures = new ArrayList();
    private final ArrayList<MobSpawnInfo.Spawners> spawnEntries = new ArrayList();
    private final ArrayList<Consumer<MobSpawnInfo.Builder>> spawnFunctions = new ArrayList();
    private float spawnChance = -1.0f;
    private boolean template = false;
    private boolean playerSpawnFriendly = false;

    private BiomeBuilder() {
    }

    public BiomeBuilder(BiomeBuilder existing) {
        if (existing.surfaceBuilder != null) {
            this.surfaceBuilder(existing.surfaceBuilder);
        }
        if (existing.precipitation != null) {
            this.precipitation(existing.precipitation);
        }
        if (existing.category != null) {
            this.category(existing.category);
        }
        if (existing.depth != null) {
            this.depth(existing.depth.floatValue());
        }
        if (existing.scale != null) {
            this.scale(existing.scale.floatValue());
        }
        if (existing.temperature != null) {
            this.temperature(existing.temperature.floatValue());
        }
        if (existing.downfall != null) {
            this.downfall(existing.downfall.floatValue());
        }
        if (existing.effects != null) {
            this.effects(existing.effects);
        }
        if (existing.temperatureModifier != null) {
            this.temperatureModifier(existing.temperatureModifier);
        }
        this.defaultFeatureFunctions.addAll(existing.defaultFeatureFunctions);
        this.features.addAll(existing.features);
        this.structureFeatures.addAll(existing.structureFeatures);
        this.spawnEntries.addAll(existing.spawnEntries);
        this.spawnFunctions.addAll(existing.spawnFunctions);
        this.spawnChance = existing.spawnChance;
        this.playerSpawnFriendly = existing.playerSpawnFriendly;
    }

    public static BiomeAmbience.Builder createDefaultBiomeAmbience() {
        return new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_242539_d(ColorConstants.getSkyColor(0.2f)).func_235239_a_(12638463);
    }

    public Biome build() {
        if (this.template) {
            throw new IllegalStateException("Tried to call build() on a frozen Builder instance!");
        }
        Biome.Builder builder = new Biome.Builder();
        builder.func_205419_a(this.category);
        builder.func_205421_a(this.depth.floatValue());
        builder.func_205420_b(this.scale.floatValue());
        builder.func_205417_d(this.downfall.floatValue());
        builder.func_205415_a(this.precipitation);
        builder.func_205414_c(this.temperature.floatValue());
        this.effects.func_242539_d(ColorConstants.getSkyColor(this.temperature.floatValue()));
        builder.func_235097_a_(this.effects.func_235238_a_());
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(this.surfaceBuilder);
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        if (this.spawnChance != -1.0f) {
            spawnSettings.func_242572_a(this.spawnChance);
        }
        for (MobSpawnInfo.Spawners spawners : this.spawnEntries) {
            spawnSettings.func_242575_a(spawners.field_242588_c.func_220339_d(), spawners);
        }
        for (Consumer consumer : this.spawnFunctions) {
            consumer.accept(spawnSettings);
        }
        if (this.playerSpawnFriendly) {
            spawnSettings.func_242571_a();
        }
        for (StructureFeature structureFeature : this.structureFeatures) {
            generationSettings.func_242516_a(structureFeature);
        }
        for (Consumer consumer : this.defaultFeatureFunctions) {
            consumer.accept(generationSettings);
        }
        for (Pair pair : this.features) {
            generationSettings.func_242513_a((GenerationStage.Decoration)pair.getFirst(), (ConfiguredFeature)pair.getSecond());
        }
        builder.func_242457_a(generationSettings.func_242508_a());
        builder.func_242458_a(spawnSettings.func_242577_b());
        return builder.func_242455_a();
    }

    public BiomeBuilder surfaceBuilder(ConfiguredSurfaceBuilder<?> surfaceBuilder) {
        this.surfaceBuilder = surfaceBuilder;
        return this;
    }

    public BiomeBuilder precipitation(Biome.RainType precipitation) {
        this.precipitation = precipitation;
        return this;
    }

    public BiomeBuilder category(Biome.Category category) {
        this.category = category;
        return this;
    }

    public BiomeBuilder depth(float depth) {
        this.depth = Float.valueOf(depth);
        return this;
    }

    public BiomeBuilder scale(float scale) {
        this.scale = Float.valueOf(scale);
        return this;
    }

    public BiomeBuilder temperature(float temperature) {
        this.temperature = Float.valueOf(temperature);
        return this;
    }

    public BiomeBuilder downfall(float downfall) {
        this.downfall = Float.valueOf(downfall);
        return this;
    }

    public BiomeBuilder effects(BiomeAmbience.Builder effects) {
        this.effects = effects;
        return this;
    }

    public BiomeBuilder addFeature(GenerationStage.Decoration step, ConfiguredFeature<?, ?> feature) {
        this.features.add(Pair.of((Object)step, feature));
        return this;
    }

    public BiomeBuilder addSpawnEntry(MobSpawnInfo.Spawners entry) {
        this.spawnEntries.add(entry);
        return this;
    }

    public BiomeBuilder addSpawnFunction(Consumer<MobSpawnInfo.Builder> function) {
        this.spawnFunctions.add(function);
        return this;
    }

    @SafeVarargs
    public final BiomeBuilder addSpawnFunctions(Consumer<MobSpawnInfo.Builder> ... functions) {
        this.spawnFunctions.addAll(Arrays.asList(functions));
        return this;
    }

    public BiomeBuilder addStructureFeature(StructureFeature<? extends IFeatureConfig, ? extends Structure<? extends IFeatureConfig>> stucture) {
        this.structureFeatures.add(stucture);
        return this;
    }

    public BiomeBuilder addDefaultFeatureFunction(Consumer<BiomeGenerationSettings.Builder> feature) {
        this.defaultFeatureFunctions.add(feature);
        return this;
    }

    @SafeVarargs
    public final BiomeBuilder addDefaultFeatureFunctions(Consumer<BiomeGenerationSettings.Builder> ... feature) {
        this.defaultFeatureFunctions.addAll(Arrays.asList(feature));
        return this;
    }

    public BiomeBuilder playerSpawnFriendly() {
        this.playerSpawnFriendly = true;
        return this;
    }

    private void markTemplate() {
        this.template = true;
    }

    public static BiomeBuilder create() {
        return new BiomeBuilder();
    }

    public BiomeBuilder temperatureModifier(Biome.TemperatureModifier temperatureModifier) {
        this.temperatureModifier = temperatureModifier;
        return this;
    }

    public static final class BiomeTemplate {
        private final BiomeBuilder builder;

        public BiomeTemplate(BiomeBuilder builder) {
            this.builder = builder;
            builder.markTemplate();
        }

        public BiomeBuilder builder() {
            return new BiomeBuilder(this.builder);
        }
    }
}

