/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.libs.repack_mysticalworld.noobutil.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import noobanidus.libs.repack_mysticalworld.noobutil.world.gen.config.WeightedBlockStateFeatureConfig;

public class WeightedLakesFeature
extends Feature<WeightedBlockStateFeatureConfig> {
    private static final BlockState AIR = Blocks.field_201941_jj.func_176223_P();

    public WeightedLakesFeature(Codec<WeightedBlockStateFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, WeightedBlockStateFeatureConfig config) {
        while (pos.func_177956_o() > 5 && reader.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        if (pos.func_177956_o() <= 4) {
            return false;
        }
        if (reader.func_241827_a(SectionPos.func_218167_a((BlockPos)(pos = pos.func_177979_c(4))), Structure.field_236381_q_).findAny().isPresent()) {
            return false;
        }
        boolean[] aboolean = new boolean[2048];
        int i = rand.nextInt(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = rand.nextDouble() * 6.0 + 3.0;
            double d1 = rand.nextDouble() * 4.0 + 2.0;
            double d2 = rand.nextDouble() * 6.0 + 3.0;
            double d3 = rand.nextDouble() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = rand.nextDouble() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = rand.nextDouble() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        aboolean[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int l2 = 0; l2 < 16; ++l2) {
                for (int k = 0; k < 8; ++k) {
                    boolean flag;
                    boolean bl = flag = !aboolean[(k1 * 16 + l2) * 8 + k] && (k1 < 15 && aboolean[((k1 + 1) * 16 + l2) * 8 + k] || k1 > 0 && aboolean[((k1 - 1) * 16 + l2) * 8 + k] || l2 < 15 && aboolean[(k1 * 16 + l2 + 1) * 8 + k] || l2 > 0 && aboolean[(k1 * 16 + (l2 - 1)) * 8 + k] || k < 7 && aboolean[(k1 * 16 + l2) * 8 + k + 1] || k > 0 && aboolean[(k1 * 16 + l2) * 8 + (k - 1)]);
                    if (!flag) continue;
                    Material material = reader.func_180495_p(pos.func_177982_a(k1, k, l2)).func_185904_a();
                    if (k >= 4 && material.func_76224_d()) {
                        return false;
                    }
                    if (k >= 4 || material.func_76220_a() || config.containsState(reader.func_180495_p(pos.func_177982_a(k1, k, l2)))) continue;
                    return false;
                }
            }
        }
        for (int l1 = 0; l1 < 16; ++l1) {
            for (int i3 = 0; i3 < 16; ++i3) {
                for (int i4 = 0; i4 < 8; ++i4) {
                    if (!aboolean[(l1 * 16 + i3) * 8 + i4]) continue;
                    reader.func_180501_a(pos.func_177982_a(l1, i4, i3), i4 >= 4 ? AIR : config.getBlockState(rand), 2);
                }
            }
        }
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                for (int j4 = 4; j4 < 8; ++j4) {
                    BlockPos blockpos;
                    if (!aboolean[(i2 * 16 + j3) * 8 + j4] || !WeightedLakesFeature.func_227250_b_((Block)reader.func_180495_p(blockpos = pos.func_177982_a(i2, j4 - 1, j3)).func_177230_c()) || reader.func_226658_a_(LightType.SKY, pos.func_177982_a(i2, j4, j3)) <= 0) continue;
                    Biome biome = reader.func_226691_t_(blockpos);
                    if (biome.func_242440_e().func_242502_e().func_204108_a().func_203425_a(Blocks.field_150391_bh)) {
                        reader.func_180501_a(blockpos, Blocks.field_150391_bh.func_176223_P(), 2);
                        continue;
                    }
                    reader.func_180501_a(blockpos, Blocks.field_196658_i.func_176223_P(), 2);
                }
            }
        }
        return true;
    }
}

