/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.libs.repack_mysticalworld.noobutil.world.gen.surfacebuilder;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.DoubleFunction;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class BeachSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private int seaLevel;
    private DoubleFunction<BlockState> sand;

    public BeachSurfaceBuilder(Codec<SurfaceBuilderConfig> codec, int seaLevel, DoubleFunction<BlockState> sand) {
        super(codec);
        this.seaLevel = seaLevel;
        this.sand = sand;
    }

    public void buildSurface(Random rand, IChunk chunk, Biome biome, int x, int z, int height, double noiseVal, BlockState var9, BlockState var10, int var11, long seed, SurfaceBuilderConfig config) {
        int localX = x & 0xF;
        int localZ = z & 0xF;
        BlockState chosenSand = this.sand.apply(noiseVal);
        int thickness = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int run = 0;
        boolean beach = false;
        boolean underwater = false;
        BlockPos.Mutable pos = new BlockPos.Mutable(localX, 0, localZ);
        for (int y = height; y >= 0; --y) {
            pos.func_181079_c(localX, y, localZ);
            BlockState chunkBlock = chunk.func_180495_p((BlockPos)pos);
            if (chunkBlock == STONE && y < 255) {
                BlockState toSet = STONE;
                BlockState up = chunk.func_180495_p(pos.func_177984_a());
                if (up.isAir((IBlockReader)chunk, pos.func_177984_a())) {
                    beach = y < this.seaLevel + 3;
                    toSet = beach ? chosenSand : config.func_204108_a();
                } else if (chunk.func_180495_p(pos.func_177984_a()) == this.WATER || run < thickness && underwater) {
                    underwater = true;
                    if (y > this.seaLevel - 3) {
                        beach = true;
                        toSet = chosenSand;
                    } else {
                        toSet = config.func_204110_c();
                    }
                } else if (y > this.seaLevel - 3) {
                    if (beach) {
                        toSet = chosenSand;
                    } else if (run < thickness) {
                        toSet = config.func_204109_b();
                    }
                }
                chunk.func_177436_a((BlockPos)pos, toSet, false);
                ++run;
                continue;
            }
            run = 0;
            beach = false;
            underwater = false;
        }
    }
}

