/*
 * Decompiled with CFR 0.152.
 */
package com.github.theniles.archery.client.models.items;

import com.github.theniles.archery.NileArchery;
import com.github.theniles.archery.items.Items;
import com.github.theniles.archery.items.projectiles.CustomArrowItem;
import com.github.theniles.archery.items.weapons.CustomBowItem;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.client.model.FabricModelPredicateProviderRegistry;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class ItemModelPredicates
implements ClientModInitializer {
    public static final class_2960 TIPPED = NileArchery.newId("tipped");
    public static final class_2960 PULLING = NileArchery.newId("pulling");
    public static final class_2960 PULL = NileArchery.newId("pull");

    private static float isBowPulling(class_1799 itemStack, class_638 clientWorld, class_1309 entity) {
        return entity != null && entity.method_6115() && entity.method_6030() == itemStack ? 1.0f : 0.0f;
    }

    private static float getBowPull(class_1799 itemStack, class_638 clientWorld, class_1309 entity) {
        if (entity == null) {
            return 0.0f;
        }
        return entity.method_6030() != itemStack ? 0.0f : ((CustomBowItem)itemStack.method_7909()).getPullProgress(entity.method_6048());
    }

    private static float isTipped(class_1799 stack, class_638 clientWorld, class_1309 entity) {
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("CustomPotionColor", 99)) {
            return 1.0f;
        }
        class_1842 potion = class_1844.method_8057((class_2487)tag);
        if (potion != null && potion != class_1847.field_8984) {
            return 1.0f;
        }
        return 0.0f;
    }

    private void registerTipped(CustomArrowItem item) {
        FabricModelPredicateProviderRegistry.register((class_1792)item, (class_2960)TIPPED, ItemModelPredicates::isTipped);
    }

    private void registerBow(CustomBowItem item) {
        FabricModelPredicateProviderRegistry.register((class_1792)item, (class_2960)PULLING, ItemModelPredicates::isBowPulling);
        FabricModelPredicateProviderRegistry.register((class_1792)item, (class_2960)PULL, ItemModelPredicates::getBowPull);
    }

    public void onInitializeClient() {
        this.registerBow(Items.GOLD_BOW);
        this.registerTipped(Items.SPECTRAL_ARROW);
        this.registerTipped(Items.ENDER_ARROW);
        this.registerTipped(Items.SEA_ARROW);
        this.registerTipped(Items.ASTRAL_ARROW);
        this.registerTipped(Items.AMETHYST_ARROW);
    }
}

