/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.networking.ModPacketsS2C;
import io.github.apace100.origins.power.Active;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.factory.condition.EntityConditionsClient;
import io.github.apace100.origins.registry.ModBlocks;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.registry.ModEntities;
import io.github.apace100.origins.screen.GameHudRender;
import io.github.apace100.origins.screen.PowerHudRenderer;
import io.github.apace100.origins.screen.ViewOriginScreen;
import io.github.apace100.origins.util.OriginsConfigSerializer;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.minecraft.class_1921;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_953;

public class OriginsClient
implements ClientModInitializer {
    public static class_304 usePrimaryActivePowerKeybind;
    public static class_304 useSecondaryActivePowerKeybind;
    public static class_304 viewCurrentOriginKeybind;
    public static ClientConfig config;
    public static boolean isServerRunningOrigins;
    private static HashMap<String, class_304> idToKeyBindingMap;
    private static HashMap<String, Boolean> lastKeyBindingStates;
    private static boolean initializedKeyBindingMap;

    public static void registerPowerKeybinding(String keyId, class_304 keyBinding) {
        idToKeyBindingMap.put(keyId, keyBinding);
    }

    @Environment(value=EnvType.CLIENT)
    public void onInitializeClient() {
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.TEMPORARY_COBWEB, class_1921.method_23581());
        EntityRendererRegistry.INSTANCE.register(ModEntities.ENDERIAN_PEARL, (dispatcher, context) -> new class_953(dispatcher, context.getItemRenderer()));
        ModPacketsS2C.register();
        EntityConditionsClient.register();
        AutoConfig.register(ClientConfig.class, OriginsConfigSerializer::new);
        config = (ClientConfig)AutoConfig.getConfigHolder(ClientConfig.class).getConfig();
        usePrimaryActivePowerKeybind = new class_304("key.origins.primary_active", class_3675.class_307.field_1668, 71, "category.origins");
        useSecondaryActivePowerKeybind = new class_304("key.origins.secondary_active", class_3675.class_307.field_1668, -1, "category.origins");
        viewCurrentOriginKeybind = new class_304("key.origins.view_origin", class_3675.class_307.field_1668, 79, "category.origins");
        OriginsClient.registerPowerKeybinding("key.origins.primary_active", usePrimaryActivePowerKeybind);
        OriginsClient.registerPowerKeybinding("key.origins.secondary_active", useSecondaryActivePowerKeybind);
        OriginsClient.registerPowerKeybinding("primary", usePrimaryActivePowerKeybind);
        OriginsClient.registerPowerKeybinding("secondary", useSecondaryActivePowerKeybind);
        KeyBindingHelper.registerKeyBinding((class_304)usePrimaryActivePowerKeybind);
        KeyBindingHelper.registerKeyBinding((class_304)useSecondaryActivePowerKeybind);
        KeyBindingHelper.registerKeyBinding((class_304)viewCurrentOriginKeybind);
        ClientTickEvents.START_CLIENT_TICK.register(tick -> {
            if (tick.field_1724 != null) {
                List<Power> powers = ((OriginComponent)ModComponents.ORIGIN.get((Object)tick.field_1724)).getPowers();
                LinkedList<Power> pressedPowers = new LinkedList<Power>();
                HashMap<String, Boolean> currentKeyBindingStates = new HashMap<String, Boolean>();
                for (Power power : powers) {
                    if (!(power instanceof Active)) continue;
                    Active active = (Active)((Object)power);
                    Active.Key key = active.getKey();
                    class_304 keyBinding = this.getKeyBinding(key.key);
                    if (keyBinding == null) continue;
                    if (!currentKeyBindingStates.containsKey(key.key)) {
                        currentKeyBindingStates.put(key.key, keyBinding.method_1434());
                    }
                    if (!((Boolean)currentKeyBindingStates.get(key.key)).booleanValue() || !key.continuous && lastKeyBindingStates.getOrDefault(key.key, false).booleanValue()) continue;
                    pressedPowers.add(power);
                }
                lastKeyBindingStates = currentKeyBindingStates;
                if (pressedPowers.size() > 0) {
                    this.performActivePowers(pressedPowers);
                }
            }
            while (viewCurrentOriginKeybind.method_1436()) {
                if (class_310.method_1551().field_1755 instanceof ViewOriginScreen) continue;
                class_310.method_1551().method_1507((class_437)new ViewOriginScreen());
            }
        });
        GameHudRender.HUD_RENDERS.add(new PowerHudRenderer());
    }

    @Environment(value=EnvType.CLIENT)
    private void performActivePowers(List<Power> powers) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.writeInt(powers.size());
        for (Power power : powers) {
            buffer.method_10812(power.getType().getIdentifier());
            ((Active)((Object)power)).onUse();
        }
        ClientPlayNetworking.send((class_2960)ModPackets.USE_ACTIVE_POWERS, (class_2540)buffer);
    }

    @Environment(value=EnvType.CLIENT)
    private class_304 getKeyBinding(String key) {
        if (!idToKeyBindingMap.containsKey(key)) {
            if (!initializedKeyBindingMap) {
                initializedKeyBindingMap = true;
                class_310 client = class_310.method_1551();
                for (int i = 0; i < client.field_1690.field_1839.length; ++i) {
                    idToKeyBindingMap.put(client.field_1690.field_1839[i].method_1431(), client.field_1690.field_1839[i]);
                }
                return this.getKeyBinding(key);
            }
            return null;
        }
        return idToKeyBindingMap.get(key);
    }

    static {
        isServerRunningOrigins = false;
        idToKeyBindingMap = new HashMap();
        lastKeyBindingStates = new HashMap();
        initializedKeyBindingMap = false;
    }

    @Config(name="origins")
    public static class ClientConfig
    implements ConfigData {
        public int xOffset = 0;
        public int yOffset = 0;
        @ConfigEntry.BoundedDiscrete(max=1L)
        public float phantomizedOverlayStrength = 0.8f;

        public void validatePostLoad() {
            if (this.phantomizedOverlayStrength < 0.0f) {
                this.phantomizedOverlayStrength = 0.0f;
            } else if (this.phantomizedOverlayStrength > 1.0f) {
                this.phantomizedOverlayStrength = 1.0f;
            }
        }
    }
}

