/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import com.mojang.authlib.GameProfile;
import io.github.apace100.origins.access.WaterMovingEntity;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.IgnoreWaterPower;
import io.github.apace100.origins.power.PowerTypes;
import io.github.apace100.origins.power.SwimmingPower;
import net.minecraft.class_1297;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_746.class})
public abstract class ClientPlayerEntityMixin
extends class_742
implements WaterMovingEntity {
    private boolean isMoving = false;
    @Shadow
    @Final
    public class_634 field_3944;

    public ClientPlayerEntityMixin(class_638 world, GameProfile profile) {
        super(world, profile);
    }

    @Inject(at={@At(value="HEAD")}, method={"getUnderwaterVisibility"}, cancellable=true)
    private void getUnderwaterVisibility(CallbackInfoReturnable<Float> info) {
        if (PowerTypes.WATER_VISION.isActive((class_1297)this)) {
            info.setReturnValue((Object)Float.valueOf(1.0f));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isSubmergedInWater"}, cancellable=true)
    private void allowSwimming(CallbackInfoReturnable<Boolean> cir) {
        if (OriginComponent.hasPower((class_1297)this, SwimmingPower.class)) {
            cir.setReturnValue((Object)true);
        } else if (OriginComponent.hasPower((class_1297)this, IgnoreWaterPower.class)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tickMovement"})
    private void beginMovementPhase(CallbackInfo ci) {
        this.isMoving = true;
    }

    @Inject(at={@At(value="TAIL")}, method={"tickMovement"})
    private void endMovementPhase(CallbackInfo ci) {
        this.isMoving = false;
    }

    @Override
    public boolean isInMovementPhase() {
        return this.isMoving;
    }
}

