/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.ActionOnWakeUp;
import io.github.apace100.origins.power.CooldownPower;
import io.github.apace100.origins.power.DisableRegenPower;
import io.github.apace100.origins.power.ElytraFlightPower;
import io.github.apace100.origins.power.IgnoreWaterPower;
import io.github.apace100.origins.power.InventoryPower;
import io.github.apace100.origins.power.ModifyDamageDealtPower;
import io.github.apace100.origins.power.ModifyExhaustionPower;
import io.github.apace100.origins.power.PowerTypes;
import io.github.apace100.origins.power.RestrictArmorPower;
import io.github.apace100.origins.power.SwimmingPower;
import io.github.apace100.origins.registry.ModBlocks;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.registry.ModDamageSources;
import net.minecraft.class_1275;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements class_1275,
class_2165 {
    @Shadow
    protected boolean field_7490;
    @Shadow
    @Final
    public class_1661 field_7514;

    @Shadow
    public abstract boolean method_5643(class_1282 var1, float var2);

    @Shadow
    public abstract class_4048 method_18377(class_4050 var1);

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    public abstract class_1542 method_7328(class_1799 var1, boolean var2);

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"updateSwimming"}, at={@At(value="TAIL")})
    private void updateSwimmingPower(CallbackInfo ci) {
        if (OriginComponent.hasPower((class_1297)this, SwimmingPower.class)) {
            this.method_5796(this.method_5624() && !this.method_5765());
            this.field_5957 = this.method_5681();
            if (this.method_5681()) {
                this.field_6017 = 0.0f;
                class_243 look = this.method_5720();
                this.method_5784(class_1313.field_6308, new class_243(look.field_1352 / 4.0, look.field_1351 / 4.0, look.field_1350 / 4.0));
            }
        } else if (OriginComponent.hasPower((class_1297)this, IgnoreWaterPower.class)) {
            this.method_5796(false);
        }
    }

    @Inject(method={"wakeUp(ZZ)V"}, at={@At(value="HEAD")})
    private void invokeWakeUpAction(boolean bl, boolean updateSleepingPlayers, CallbackInfo ci) {
        if (!bl && !updateSleepingPlayers && this.method_18398().isPresent()) {
            class_2338 sleepingPos = (class_2338)this.method_18398().get();
            OriginComponent.getPowers((class_1297)this, ActionOnWakeUp.class).stream().filter(p -> p.doesApply(sleepingPos)).forEach(p -> p.executeActions(sleepingPos, class_2350.field_11033));
        }
    }

    @Inject(method={"canFoodHeal"}, at={@At(value="HEAD")}, cancellable=true)
    private void disableHeal(CallbackInfoReturnable<Boolean> info) {
        if (OriginComponent.hasPower((class_1297)this, DisableRegenPower.class)) {
            info.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"addExhaustion"}, ordinal=0, name={"exhaustion"})
    private float modifyExhaustion(float exhaustionIn) {
        return OriginComponent.modify((class_1297)this, ModifyExhaustionPower.class, exhaustionIn);
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE", ordinal=0), name={"f"}, ordinal=0)
    public float modifyDamage(float f, class_1297 target) {
        class_1282 source = class_1282.method_5532((class_1657)((class_1657)this));
        return OriginComponent.modify((class_1297)this, ModifyDamageDealtPower.class, f, p -> p.doesApply(source, f, target instanceof class_1309 ? (class_1309)target : null), p -> p.executeActions(target));
    }

    @Inject(at={@At(value="HEAD")}, method={"slowMovement"}, cancellable=true)
    public void slowMovement(class_2680 state, class_243 multiplier, CallbackInfo info) {
        if (PowerTypes.NO_COBWEB_SLOWDOWN.isActive((class_1297)this) || PowerTypes.MASTER_OF_WEBS_NO_SLOWDOWN.isActive((class_1297)this)) {
            info.cancel();
        }
    }

    @ModifyConstant(method={"getBlockBreakingSpeed"}, constant={@Constant(ordinal=0, floatValue=5.0f)})
    private float modifyWaterBlockBreakingSpeed(float in) {
        if (PowerTypes.AQUA_AFFINITY.isActive((class_1297)this)) {
            return 1.0f;
        }
        return in;
    }

    @ModifyConstant(method={"getBlockBreakingSpeed"}, constant={@Constant(ordinal=1, floatValue=5.0f)})
    private float modifyUngroundedBlockBreakingSpeed(float in) {
        if (this.method_5816() && PowerTypes.AQUA_AFFINITY.isActive((class_1297)this)) {
            return 1.0f;
        }
        return in;
    }

    @Inject(method={"dropInventory"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;dropAll()V")})
    private void dropAdditionalInventory(CallbackInfo ci) {
        OriginComponent.getPowers((class_1297)this, InventoryPower.class).forEach(inventory -> {
            if (inventory.shouldDropOnDeath()) {
                for (int i = 0; i < inventory.method_5439(); ++i) {
                    class_1799 itemStack = inventory.method_5438(i);
                    if (!inventory.shouldDropOnDeath(itemStack)) continue;
                    if (!itemStack.method_7960() && class_1890.method_8221((class_1799)itemStack)) {
                        inventory.method_5441(i);
                        continue;
                    }
                    ((class_1657)this).method_7329(itemStack, true, false);
                    inventory.method_5447(i, class_1799.field_8037);
                }
            }
        });
    }

    @Inject(method={"canEquip"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventArmorDispensing(class_1799 stack, CallbackInfoReturnable<Boolean> info) {
        class_1304 slot = class_1308.method_5953((class_1799)stack);
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)this);
        if (component.getPowers(RestrictArmorPower.class).stream().anyMatch(rap -> !rap.canEquip(stack, slot))) {
            info.setReturnValue((Object)false);
        }
        if (stack.method_7909() == class_1802.field_8833 && OriginComponent.getPowers((class_1297)this, ElytraFlightPower.class).size() > 0) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void tick(CallbackInfo info) {
        if (PowerTypes.WATER_BREATHING.isActive((class_1297)this)) {
            if (!(this.method_5777((class_3494)class_3486.field_15517) || this.method_6059(class_1294.field_5923) || this.method_6059(class_1294.field_5927))) {
                if (!this.isRainingAtPlayerPosition()) {
                    int landGain = this.method_6064(0);
                    this.method_5855(this.method_6130(this.method_5669()) - landGain);
                    if (this.method_5669() == -20) {
                        this.method_5855(0);
                        for (int i = 0; i < 8; ++i) {
                            double f = this.field_5974.nextDouble() - this.field_5974.nextDouble();
                            double g = this.field_5974.nextDouble() - this.field_5974.nextDouble();
                            double h = this.field_5974.nextDouble() - this.field_5974.nextDouble();
                            this.field_6002.method_8406((class_2394)class_2398.field_11247, this.method_23322(0.5), this.method_23320() + this.field_5974.nextGaussian() * 0.08, this.method_23325(0.5), f * 0.5, g * 0.5 + 0.25, h * 0.5);
                        }
                        this.method_5643(ModDamageSources.NO_WATER_FOR_GILLS, 2.0f);
                    }
                } else {
                    int landGain = this.method_6064(0);
                    this.method_5855(this.method_5669() - landGain);
                }
            } else if (this.method_5669() < this.method_5748()) {
                this.method_5855(this.method_6064(this.method_5669()));
            }
        }
    }

    private boolean isRainingAtPlayerPosition() {
        class_2338 blockPos = this.method_24515();
        return this.field_6002.method_8520(blockPos) || this.field_6002.method_8520(blockPos.method_10080(0.0, (double)this.method_18377((class_4050)this.method_18376()).field_18068, 0.0));
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;isSubmergedIn(Lnet/minecraft/tag/Tag;)Z"), method={"updateTurtleHelmet"})
    public boolean isSubmergedInProxy(class_1657 player, class_3494<class_3611> fluidTag) {
        boolean submerged = this.method_5777(fluidTag);
        if (PowerTypes.WATER_BREATHING.isActive((class_1297)this)) {
            return !submerged;
        }
        return submerged;
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;onAttacking(Lnet/minecraft/entity/Entity;)V")}, method={"attack"})
    public void cobwebOnMeleeAttack(class_1297 target, CallbackInfo info) {
        class_2338 targetPos;
        CooldownPower power;
        if (target instanceof class_1309 && PowerTypes.WEBBING.isActive((class_1297)this) && !this.method_5715() && (power = PowerTypes.WEBBING.get((class_1297)this)).canUse() && (this.field_6002.method_22347(targetPos = target.method_24515()) || this.field_6002.method_8320(targetPos).method_26207().method_15800())) {
            this.field_6002.method_8501(targetPos, ModBlocks.TEMPORARY_COBWEB.method_9564());
            power.use();
        }
    }
}

