/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.ActionOnBlockBreakPower;
import io.github.apace100.origins.power.ModifyHarvestPower;
import io.github.apace100.origins.power.PreventBlockUsePower;
import io.github.apace100.origins.util.SavedBlockPosition;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_3225.class})
public class ServerPlayerInteractionManagerMixin {
    @Shadow
    public class_3218 field_14007;
    @Shadow
    public class_3222 field_14008;
    private SavedBlockPosition savedBlockPosition;

    @Inject(method={"tryBreakBlock"}, at={@At(value="HEAD")})
    private void cacheBlock(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        this.savedBlockPosition = new SavedBlockPosition((class_4538)this.field_14007, pos);
    }

    @ModifyVariable(method={"tryBreakBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;postMine(Lnet/minecraft/world/World;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/player/PlayerEntity;)V"), ordinal=1)
    private boolean modifyEffectiveTool(boolean original) {
        for (ModifyHarvestPower mhp : OriginComponent.getPowers((class_1297)this.field_14008, ModifyHarvestPower.class)) {
            if (!mhp.doesApply(this.savedBlockPosition)) continue;
            return mhp.isHarvestAllowed();
        }
        return original;
    }

    @Inject(method={"tryBreakBlock"}, at={@At(value="RETURN", ordinal=4)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void actionOnBlockBreak(class_2338 pos, CallbackInfoReturnable<Boolean> cir, class_2680 blockState, class_2586 blockEntity, class_2248 block, boolean bl, class_1799 itemStack, class_1799 itemStack2, boolean bl2) {
        OriginComponent.getPowers((class_1297)this.field_14008, ActionOnBlockBreakPower.class).stream().filter(p -> p.doesApply(this.savedBlockPosition)).forEach(aobbp -> aobbp.executeActions(bl && bl2, pos, null));
    }

    @Inject(method={"interactBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;shouldCancelInteraction()Z")}, cancellable=true)
    private void preventBlockInteraction(class_3222 player, class_1937 world, class_1799 stack, class_1268 hand, class_3965 hitResult, CallbackInfoReturnable<class_1269> cir) {
        if (OriginComponent.getPowers((class_1297)player, PreventBlockUsePower.class).stream().anyMatch(p -> p.doesPrevent((class_4538)world, hitResult.method_17777()))) {
            cir.setReturnValue((Object)class_1269.field_5814);
        }
    }
}

