/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.VariableIntPower;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;

public class DamageOverTimePower
extends VariableIntPower {
    private final int damageTickInterval;
    private final int beginDamageIn;
    private final float damageAmountEasy;
    private final float damageAmount;
    private final class_1282 damageSource;
    private final class_1887 protectingEnchantment;
    private final float protectionEffectiveness;
    private int outOfDamageTicks;

    public DamageOverTimePower(PowerType<?> type, class_1657 player, int beginDamageIn, int damageInterval, float damageAmountEasy, float damageAmount, class_1282 damageSource, class_1887 protectingEnchantment, float protectionEffectiveness) {
        super(type, player, beginDamageIn, 0, Math.max(damageInterval, beginDamageIn));
        this.damageSource = damageSource;
        this.beginDamageIn = beginDamageIn;
        this.damageAmount = damageAmount;
        this.damageAmountEasy = damageAmountEasy;
        this.protectingEnchantment = protectingEnchantment;
        this.protectionEffectiveness = protectionEffectiveness;
        this.damageTickInterval = damageInterval;
        this.setTicking(true);
    }

    @Override
    public int getMax() {
        return Math.max(super.getMax(), this.getDamageBegin());
    }

    public int getDamageBegin() {
        int prot = this.getProtection();
        if (prot >= 64) {
            return 24000;
        }
        prot = (int)((float)(prot * 2 * 20) * this.protectionEffectiveness);
        return this.beginDamageIn + prot;
    }

    @Override
    public void tick() {
        if (this.isActive()) {
            this.doDamage();
        } else {
            this.resetDamage();
        }
    }

    public void doDamage() {
        this.outOfDamageTicks = 0;
        if (this.getValue() <= 0) {
            this.setValue(this.damageTickInterval);
            this.player.method_5643(this.damageSource, this.player.field_6002.method_8407() == class_1267.field_5805 ? this.damageAmountEasy : this.damageAmount);
        } else {
            this.decrement();
        }
    }

    public void resetDamage() {
        if (this.outOfDamageTicks >= 20) {
            this.setValue(this.getDamageBegin());
        } else {
            ++this.outOfDamageTicks;
        }
    }

    private int getProtection() {
        if (this.protectingEnchantment == null) {
            return 0;
        }
        Map enchantedItems = this.protectingEnchantment.method_8185((class_1309)this.player);
        Collection iterable = enchantedItems.values();
        int i = 0;
        for (class_1799 itemStack : iterable) {
            i += class_1890.method_8225((class_1887)this.protectingEnchantment, (class_1799)itemStack);
        }
        return i * enchantedItems.size();
    }
}

