/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.mixin.EyeHeightAccess;
import io.github.apace100.origins.power.ActiveCooldownPower;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.util.HudRender;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1676;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class FireProjectilePower
extends ActiveCooldownPower {
    private final class_1299 entityType;
    private final int projectileCount;
    private final float speed;
    private final float divergence;
    private final class_3414 soundEvent;
    private final class_2487 tag;

    public FireProjectilePower(PowerType<?> type, class_1657 player, int cooldownDuration, HudRender hudRender, class_1299 entityType, int projectileCount, float speed, float divergence, class_3414 soundEvent, class_2487 tag) {
        super(type, player, cooldownDuration, hudRender, null);
        this.entityType = entityType;
        this.projectileCount = projectileCount;
        this.speed = speed;
        this.divergence = divergence;
        this.soundEvent = soundEvent;
        this.tag = tag;
    }

    @Override
    public void onUse() {
        if (this.canUse()) {
            this.fireProjectiles();
            this.use();
        }
    }

    private void fireProjectiles() {
        if (this.soundEvent != null) {
            this.player.field_6002.method_8465((class_1657)null, this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), this.soundEvent, class_3419.field_15254, 0.5f, 0.4f / (this.player.method_6051().nextFloat() * 0.4f + 0.8f));
        }
        if (!this.player.field_6002.field_9236) {
            for (int i = 0; i < this.projectileCount; ++i) {
                this.fireProjectile();
            }
        }
    }

    private void fireProjectile() {
        if (this.entityType != null) {
            class_1297 entity = this.entityType.method_5883(this.player.field_6002);
            if (entity == null) {
                return;
            }
            class_243 rotationVector = this.player.method_5720();
            class_243 spawnPos = this.player.method_19538().method_1031(0.0, (double)((EyeHeightAccess)this.player).callGetEyeHeight(this.player.method_18376(), this.player.method_18377(this.player.method_18376())), 0.0).method_1019(rotationVector);
            entity.method_5808(spawnPos.method_10216(), spawnPos.method_10214(), spawnPos.method_10215(), this.player.field_5965, this.player.field_6031);
            if (entity instanceof class_1676) {
                if (entity instanceof class_1668) {
                    class_1668 explosiveProjectileEntity = (class_1668)entity;
                    explosiveProjectileEntity.field_7601 = rotationVector.field_1352 * (double)this.speed;
                    explosiveProjectileEntity.field_7600 = rotationVector.field_1351 * (double)this.speed;
                    explosiveProjectileEntity.field_7599 = rotationVector.field_1350 * (double)this.speed;
                }
                class_1676 projectile = (class_1676)entity;
                projectile.method_7432((class_1297)this.player);
                projectile.method_24919((class_1297)this.player, this.player.field_5965, this.player.field_6031, 0.0f, this.speed, this.divergence);
            } else {
                float f = -class_3532.method_15374((float)(this.player.field_6031 * ((float)Math.PI / 180))) * class_3532.method_15362((float)(this.player.field_5965 * ((float)Math.PI / 180)));
                float g = -class_3532.method_15374((float)(this.player.field_5965 * ((float)Math.PI / 180)));
                float h = class_3532.method_15362((float)(this.player.field_6031 * ((float)Math.PI / 180))) * class_3532.method_15362((float)(this.player.field_5965 * ((float)Math.PI / 180)));
                class_243 vec3d = new class_243((double)f, (double)g, (double)h).method_1029().method_1031(this.player.method_6051().nextGaussian() * (double)0.0075f * (double)this.divergence, this.player.method_6051().nextGaussian() * (double)0.0075f * (double)this.divergence, this.player.method_6051().nextGaussian() * (double)0.0075f * (double)this.divergence).method_1021((double)this.speed);
                entity.method_18799(vec3d);
                class_243 playerVelo = this.player.method_18798();
                entity.method_18799(entity.method_18798().method_1031(playerVelo.field_1352, this.player.method_24828() ? 0.0 : playerVelo.field_1351, playerVelo.field_1350));
            }
            if (this.tag != null) {
                class_2487 mergedTag = entity.method_5647(new class_2487());
                mergedTag.method_10543(this.tag);
                entity.method_5651(mergedTag);
            }
            this.player.field_6002.method_8649(entity);
        }
    }
}

