/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2810;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3414;
import net.minecraft.class_3449;
import net.minecraft.class_3545;
import net.minecraft.class_3902;
import net.minecraft.class_4076;
import net.minecraft.class_5275;
import net.minecraft.class_5321;

public class ModifyPlayerSpawnPower
extends Power {
    public final class_5321<class_1937> dimension;
    public final float dimensionDistanceMultiplier;
    public final class_2960 biomeId;
    public final String spawnStrategy;
    public final class_3195 structure;
    public final class_3414 spawnSound;

    public ModifyPlayerSpawnPower(PowerType<?> type, class_1657 player, class_5321<class_1937> dimension, float dimensionDistanceMultiplier, class_2960 biomeId, String spawnStrategy, class_3195<?> structure, class_3414 spawnSound) {
        super(type, player);
        this.dimension = dimension;
        this.dimensionDistanceMultiplier = dimensionDistanceMultiplier;
        this.biomeId = biomeId;
        this.spawnStrategy = spawnStrategy;
        this.structure = structure;
        this.spawnSound = spawnSound;
    }

    @Override
    public void onChosen(boolean isOrbOfOrigin) {
        if (this.player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)this.player;
            class_3545<class_3218, class_2338> spawn = this.getSpawn(false);
            if (spawn != null && !isOrbOfOrigin) {
                class_243 tpPos = class_5275.method_30769((class_1299)class_1299.field_6097, (class_1941)((class_1941)spawn.method_15442()), (class_2338)((class_2338)spawn.method_15441()), (boolean)true);
                if (tpPos != null) {
                    serverPlayer.method_14251((class_3218)spawn.method_15442(), tpPos.field_1352, tpPos.field_1351, tpPos.field_1350, this.player.field_5965, this.player.field_6031);
                } else {
                    serverPlayer.method_14251((class_3218)spawn.method_15442(), (double)((class_2338)spawn.method_15441()).method_10263(), (double)((class_2338)spawn.method_15441()).method_10264(), (double)((class_2338)spawn.method_15441()).method_10260(), this.player.field_5965, this.player.field_6031);
                    Origins.LOGGER.warn("Could not spawn player with `ModifySpawnPower` at the desired location.");
                }
            }
        }
    }

    @Override
    public void onRemoved() {
        class_3222 serverPlayer;
        if (this.player instanceof class_3222 && (serverPlayer = (class_3222)this.player).method_26280() != null && serverPlayer.method_26282()) {
            serverPlayer.method_26284(class_1937.field_25179, null, 0.0f, false, false);
        }
    }

    public class_3545<class_3218, class_2338> getSpawn(boolean isSpawnObstructed) {
        if (this.player instanceof class_3222) {
            class_243 tpPos;
            class_2338 spawnToDimPos;
            class_3222 serverPlayer = (class_3222)this.player;
            class_3218 world = serverPlayer.method_14220().method_8503().method_3847(this.dimension);
            class_2338 regularSpawn = serverPlayer.method_14220().method_8503().method_3847(class_1937.field_25179).method_27911();
            int iterations = world.method_24853() / 2 - 8;
            int center = world.method_24853() / 2;
            int range = 64;
            switch (this.spawnStrategy) {
                case "center": {
                    spawnToDimPos = new class_2338(0, center, 0);
                    break;
                }
                case "default": {
                    if (this.dimensionDistanceMultiplier != 0.0f) {
                        spawnToDimPos = new class_2338((double)((float)regularSpawn.method_10263() * this.dimensionDistanceMultiplier), (double)regularSpawn.method_10264(), (double)((float)regularSpawn.method_10260() * this.dimensionDistanceMultiplier));
                        break;
                    }
                    spawnToDimPos = new class_2338(regularSpawn.method_10263(), regularSpawn.method_10264(), regularSpawn.method_10260());
                    break;
                }
                default: {
                    Origins.LOGGER.warn("This case does nothing. The game crashes if there is no spawn strategy set");
                    spawnToDimPos = this.dimensionDistanceMultiplier != 0.0f ? new class_2338((double)((float)regularSpawn.method_10263() * this.dimensionDistanceMultiplier), (double)regularSpawn.method_10264(), (double)((float)regularSpawn.method_10260() * this.dimensionDistanceMultiplier)) : new class_2338(regularSpawn.method_10263(), regularSpawn.method_10264(), regularSpawn.method_10260());
                }
            }
            if (this.biomeId != null) {
                Optional biomeOptional = world.method_30349().method_30530(class_2378.field_25114).method_17966(this.biomeId);
                if (biomeOptional.isPresent()) {
                    class_2338 biomePos = world.method_24500((class_1959)biomeOptional.get(), spawnToDimPos, 6400, 8);
                    if (biomePos != null) {
                        spawnToDimPos = biomePos;
                    } else {
                        Origins.LOGGER.warn("Could not find biome \"" + this.biomeId.toString() + "\" in dimension \"" + this.dimension.toString() + "\".");
                    }
                } else {
                    Origins.LOGGER.warn("Biome with ID \"" + this.biomeId.toString() + "\" was not registered.");
                }
            }
            if (this.structure == null) {
                tpPos = this.getValidSpawn(spawnToDimPos, range, world);
            } else {
                class_2338 structurePos = this.getStructureLocation(this.structure, this.dimension);
                if (structurePos == null) {
                    return null;
                }
                class_1923 structureChunkPos = new class_1923(structurePos.method_10263() >> 4, structurePos.method_10260() >> 4);
                class_3449 structureStart = world.method_27056().method_26975(class_4076.method_18681((class_1923)structureChunkPos, (int)0), this.structure, (class_2810)world.method_22350(structurePos));
                class_2338 structureCenter = new class_2338(structureStart.method_14968().method_22874());
                tpPos = this.getValidSpawn(structureCenter, range, world);
            }
            if (tpPos != null) {
                class_2338.class_2339 mutable;
                class_2338.class_2339 spawnLocation = mutable = new class_2338(tpPos.field_1352, tpPos.field_1351, tpPos.field_1350).method_25503();
                world.method_14178().method_17297(class_3230.field_14030, new class_1923((class_2338)spawnLocation), 11, (Object)class_3902.field_17274);
                return new class_3545((Object)world, (Object)spawnLocation);
            }
            return null;
        }
        return null;
    }

    private class_2338 getStructureLocation(class_3195 structure, class_5321<class_1937> dimension) {
        class_2338 blockPos = new class_2338(0, 70, 0);
        class_3218 serverWorld = this.player.method_5682().method_3847(dimension);
        class_2338 blockPos2 = serverWorld.method_8487(structure, blockPos, 100, false);
        if (blockPos2 == null) {
            Origins.LOGGER.warn("Could not find '" + structure.method_14019() + "' in dimension: " + dimension.method_29177());
            return null;
        }
        return blockPos2;
    }

    private class_243 getValidSpawn(class_2338 startPos, int range, class_3218 world) {
        int dx = 1;
        int dz = 0;
        int segmentLength = 1;
        class_2338.class_2339 mutable = startPos.method_25503();
        int center = startPos.method_10264();
        int x = startPos.method_10263();
        int z = startPos.method_10260();
        int segmentPassed = 0;
        int i = 0;
        for (int d = 0; i < world.method_24853() || d > 0; ++i, --d) {
            for (int coordinateCount = 0; coordinateCount < range; ++coordinateCount) {
                ++segmentPassed;
                mutable.method_20787(x += dx);
                mutable.method_20788(z += dz);
                mutable.method_10099(center + i);
                class_243 tpPos = class_5275.method_30769((class_1299)class_1299.field_6097, (class_1941)world, (class_2338)mutable, (boolean)true);
                if (tpPos != null) {
                    return tpPos;
                }
                mutable.method_10099(center + d);
                tpPos = class_5275.method_30769((class_1299)class_1299.field_6097, (class_1941)world, (class_2338)mutable, (boolean)true);
                if (tpPos != null) {
                    return tpPos;
                }
                if (segmentPassed != segmentLength) continue;
                segmentPassed = 0;
                int buffer = dx;
                dx = -dz;
                dz = buffer;
                if (dz != 0) continue;
                ++segmentLength;
            }
        }
        return null;
    }
}

