/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.CooldownPower;
import io.github.apace100.origins.power.MultiplePowerType;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeReference;
import io.github.apace100.origins.power.PowerTypeRegistry;
import io.github.apace100.origins.power.ToggleNightVisionPower;
import io.github.apace100.origins.power.TogglePower;
import io.github.apace100.origins.power.factory.PowerFactory;
import io.github.apace100.origins.registry.ModRegistries;
import io.github.apace100.origins.util.MultiJsonDataLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;

public class PowerTypes
extends MultiJsonDataLoader
implements IdentifiableResourceReloadListener {
    public static String CURRENT_NAMESPACE = "";
    public static String CURRENT_PATH = "";
    private static final class_2960 MULTIPLE = Origins.identifier("multiple");
    private static final class_2960 SIMPLE = Origins.identifier("simple");
    public static final PowerType<Power> WATER_BREATHING = new PowerTypeReference<Power>(new class_2960("origins", "water_breathing"));
    public static final PowerType<Power> CONDUIT_POWER_ON_LAND = new PowerTypeReference<Power>(new class_2960("origins", "conduit_power_on_land"));
    public static final PowerType<Power> AQUA_AFFINITY = new PowerTypeReference<Power>(new class_2960("origins", "aqua_affinity"));
    public static final PowerType<ToggleNightVisionPower> WATER_VISION = new PowerTypeReference<ToggleNightVisionPower>(new class_2960("origins", "water_vision"));
    public static final PowerType<Power> LIKE_WATER = new PowerTypeReference<Power>(new class_2960("origins", "like_water"));
    public static final PowerType<CooldownPower> WEBBING = new PowerTypeReference<CooldownPower>(new class_2960("origins", "webbing"));
    public static final PowerType<TogglePower> CLIMBING = new PowerTypeReference<TogglePower>(new class_2960("origins", "climbing"));
    public static final PowerType<Power> NO_COBWEB_SLOWDOWN = new PowerTypeReference<Power>(new class_2960("origins", "no_cobweb_slowdown"));
    public static final PowerType<Power> MASTER_OF_WEBS_NO_SLOWDOWN = new PowerTypeReference<Power>(new class_2960("origins", "master_of_webs_no_slowdown"));
    public static final PowerType<Power> SLOW_FALLING = new PowerTypeReference<Power>(new class_2960("origins", "slow_falling"));
    public static final PowerType<Power> SCARE_CREEPERS = new PowerTypeReference<Power>(new class_2960("origins", "scare_creepers"));
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final HashMap<class_2960, Integer> loadingPriorities = new HashMap();

    public PowerTypes() {
        super(GSON, "powers");
    }

    protected void apply(Map<class_2960, List<JsonElement>> loader, class_3300 manager, class_3695 profiler) {
        PowerTypeRegistry.reset();
        this.loadingPriorities.clear();
        loader.forEach((id, jel) -> jel.forEach(je -> {
            try {
                CURRENT_NAMESPACE = id.method_12836();
                CURRENT_PATH = id.method_12832();
                JsonObject jo = je.getAsJsonObject();
                class_2960 factoryId = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jo, (String)"type"));
                if (MULTIPLE.equals((Object)factoryId)) {
                    LinkedList<class_2960> subPowers = new LinkedList<class_2960>();
                    for (Map.Entry entry : jo.entrySet()) {
                        if (((String)entry.getKey()).equals("type") || ((String)entry.getKey()).equals("loading_priority") || ((String)entry.getKey()).equals("name") || ((String)entry.getKey()).equals("description") || ((String)entry.getKey()).equals("hidden") || ((String)entry.getKey()).equals("condition")) continue;
                        class_2960 subId = new class_2960(id.toString() + "_" + (String)entry.getKey());
                        try {
                            this.readPower(subId, (JsonElement)entry.getValue(), true);
                            subPowers.add(subId);
                        }
                        catch (Exception e) {
                            Origins.LOGGER.error("There was a problem reading sub-power \"" + subId.toString() + "\" in power file \"" + id.toString() + "\": " + e.getMessage());
                        }
                    }
                    MultiplePowerType superPower = (MultiplePowerType)this.readPower((class_2960)id, (JsonElement)je, false, MultiplePowerType::new);
                    superPower.setSubPowers(subPowers);
                } else {
                    this.readPower((class_2960)id, (JsonElement)je, false);
                }
            }
            catch (Exception e) {
                Origins.LOGGER.error("There was a problem reading power file " + id.toString() + " (skipping): " + e.getMessage());
            }
        }));
        this.loadingPriorities.clear();
        CURRENT_NAMESPACE = null;
        CURRENT_PATH = null;
        Origins.LOGGER.info("Finished loading powers from data files. Registry contains " + PowerTypeRegistry.size() + " powers.");
    }

    private void readPower(class_2960 id, JsonElement je, boolean isSubPower) {
        this.readPower(id, je, isSubPower, PowerType::new);
    }

    private PowerType readPower(class_2960 id, JsonElement je, boolean isSubPower, BiFunction<class_2960, PowerFactory.Instance, PowerType> powerTypeFactory) {
        Optional optionalFactory;
        JsonObject jo = je.getAsJsonObject();
        class_2960 factoryId = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jo, (String)"type"));
        if (MULTIPLE.equals((Object)factoryId)) {
            factoryId = SIMPLE;
            if (isSubPower) {
                throw new JsonSyntaxException("Power type \"" + MULTIPLE.toString() + "\" may not be used for a sub-power of another \"" + MULTIPLE.toString() + "\" power.");
            }
        }
        if (!(optionalFactory = ModRegistries.POWER_FACTORY.method_17966(factoryId)).isPresent()) {
            throw new JsonSyntaxException("Power type \"" + factoryId.toString() + "\" is not defined.");
        }
        PowerFactory.Instance factoryInstance = ((PowerFactory)optionalFactory.get()).read(jo);
        PowerType type = powerTypeFactory.apply(id, factoryInstance);
        int priority = class_3518.method_15282((JsonObject)jo, (String)"loading_priority", (int)0);
        String name = class_3518.method_15253((JsonObject)jo, (String)"name", (String)"");
        String description = class_3518.method_15253((JsonObject)jo, (String)"description", (String)"");
        boolean hidden = class_3518.method_15258((JsonObject)jo, (String)"hidden", (boolean)false);
        if (hidden || isSubPower) {
            type.setHidden();
        }
        type.setTranslationKeys(name, description);
        if (!PowerTypeRegistry.contains(id)) {
            PowerTypeRegistry.register(id, type);
            this.loadingPriorities.put(id, priority);
        } else if (this.loadingPriorities.get(id) < priority) {
            PowerTypeRegistry.update(id, type);
            this.loadingPriorities.put(id, priority);
        }
        return type;
    }

    public class_2960 getFabricId() {
        return new class_2960("origins", "powers");
    }

    private static <T extends Power> PowerType<T> register(String path, PowerType<T> type) {
        return new PowerTypeReference(new class_2960("origins", path));
    }
}

