/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.StatusEffectPower;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_2497;
import net.minecraft.class_2520;

public class StackingStatusEffectPower
extends StatusEffectPower {
    private final int minStack;
    private final int maxStack;
    private final int durationPerStack;
    private int currentStack;

    public StackingStatusEffectPower(PowerType<?> type, class_1657 player, int minStack, int maxStack, int durationPerStack) {
        super(type, player);
        this.minStack = minStack;
        this.maxStack = maxStack;
        this.durationPerStack = durationPerStack;
    }

    @Override
    public void tick() {
        if (this.isActive()) {
            ++this.currentStack;
            if (this.currentStack > this.maxStack) {
                this.currentStack = this.maxStack;
            }
            if (this.currentStack > 0) {
                this.applyEffects();
            }
        } else {
            --this.currentStack;
            if (this.currentStack < this.minStack) {
                this.currentStack = this.minStack;
            }
        }
    }

    @Override
    public void applyEffects() {
        this.effects.forEach(sei -> {
            int duration = this.durationPerStack * this.currentStack;
            if (duration > 0) {
                class_1293 applySei = new class_1293(sei.method_5579(), duration, sei.method_5578(), sei.method_5591(), sei.method_5581(), sei.method_5592());
                this.player.method_6092(applySei);
            }
        });
    }

    @Override
    public class_2520 toTag() {
        return class_2497.method_23247((int)this.currentStack);
    }

    @Override
    public void fromTag(class_2520 tag) {
        this.currentStack = ((class_2497)tag).method_10701();
    }
}

