/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.action;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.CooldownPower;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.VariableIntPower;
import io.github.apace100.origins.power.factory.action.ActionFactory;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.registry.ModRegistries;
import io.github.apace100.origins.util.ClassUtil;
import io.github.apace100.origins.util.FilterableWeightedList;
import io.github.apace100.origins.util.Scheduler;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import io.github.apace100.origins.util.Space;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1160;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.util.TriConsumer;

public class EntityActions {
    public static void register() {
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("and"), new SerializableData().add("actions", SerializableDataType.ENTITY_ACTIONS), (data, entity) -> ((List)data.get("actions")).forEach(e -> e.accept(entity))));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("chance"), new SerializableData().add("action", SerializableDataType.ENTITY_ACTION).add("chance", SerializableDataType.FLOAT), (data, entity) -> {
            Random random = new Random();
            if (random.nextFloat() < data.getFloat("chance")) {
                ((ActionFactory.Instance)data.get("action")).accept(entity);
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("if_else"), new SerializableData().add("condition", SerializableDataType.ENTITY_CONDITION).add("if_action", SerializableDataType.ENTITY_ACTION).add("else_action", SerializableDataType.ENTITY_ACTION, null), (data, entity) -> {
            if (entity instanceof class_1309) {
                if (((ConditionFactory.Instance)data.get("condition")).test((class_1309)entity)) {
                    ((ActionFactory.Instance)data.get("if_action")).accept(entity);
                } else if (data.isPresent("else_action")) {
                    ((ActionFactory.Instance)data.get("else_action")).accept(entity);
                }
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("choice"), new SerializableData().add("actions", SerializableDataType.weightedList(SerializableDataType.ENTITY_ACTION)), (data, entity) -> {
            FilterableWeightedList actionList = (FilterableWeightedList)((Object)((Object)data.get("actions")));
            ActionFactory.Instance action = (ActionFactory.Instance)actionList.method_23337(new Random());
            action.accept(entity);
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("if_else_list"), new SerializableData().add("actions", SerializableDataType.list(SerializableDataType.compound(ClassUtil.castClass(class_3545.class), new SerializableData().add("action", SerializableDataType.ENTITY_ACTION).add("condition", SerializableDataType.ENTITY_CONDITION), inst -> new class_3545((Object)((ConditionFactory.Instance)inst.get("condition")), (Object)((ActionFactory.Instance)inst.get("action"))), (data, pair) -> {
            SerializableData.Instance inst = (SerializableData)data.new SerializableData.Instance();
            inst.set("condition", pair.method_15442());
            inst.set("action", pair.method_15441());
            return inst;
        }))), (data, entity) -> {
            if (entity instanceof class_1309) {
                List actions = (List)data.get("actions");
                for (class_3545 action : actions) {
                    if (!((ConditionFactory.Instance)action.method_15442()).test(entity)) continue;
                    ((ActionFactory.Instance)action.method_15441()).accept(entity);
                    break;
                }
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("damage"), new SerializableData().add("amount", SerializableDataType.FLOAT).add("source", SerializableDataType.DAMAGE_SOURCE), (data, entity) -> entity.method_5643((class_1282)data.get("source"), data.getFloat("amount"))));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("heal"), new SerializableData().add("amount", SerializableDataType.FLOAT), (data, entity) -> {
            if (entity instanceof class_1309) {
                ((class_1309)entity).method_6025(data.getFloat("amount"));
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("play_sound"), new SerializableData().add("sound", SerializableDataType.SOUND_EVENT).add("volume", SerializableDataType.FLOAT, Float.valueOf(1.0f)).add("pitch", SerializableDataType.FLOAT, Float.valueOf(1.0f)), (data, entity) -> {
            if (entity instanceof class_1657) {
                entity.field_6002.method_8465((class_1657)null, entity.method_23317(), entity.method_23318(), entity.method_23321(), (class_3414)data.get("sound"), class_3419.field_15248, data.getFloat("volume"), data.getFloat("pitch"));
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("exhaust"), new SerializableData().add("amount", SerializableDataType.FLOAT), (data, entity) -> {
            if (entity instanceof class_1657) {
                ((class_1657)entity).method_7344().method_7583(data.getFloat("amount"));
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("apply_effect"), new SerializableData().add("effect", SerializableDataType.STATUS_EFFECT_INSTANCE, null).add("effects", SerializableDataType.STATUS_EFFECT_INSTANCES, null), (data, entity) -> {
            if (entity instanceof class_1309 && !entity.field_6002.field_9236) {
                class_1309 le = (class_1309)entity;
                if (data.isPresent("effect")) {
                    class_1293 effect = (class_1293)data.get("effect");
                    le.method_6092(new class_1293(effect));
                }
                if (data.isPresent("effects")) {
                    ((List)data.get("effects")).forEach(e -> le.method_6092(new class_1293(e)));
                }
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("clear_effect"), new SerializableData().add("effect", SerializableDataType.STATUS_EFFECT, null), (data, entity) -> {
            if (entity instanceof class_1309) {
                class_1309 le = (class_1309)entity;
                if (data.isPresent("effect")) {
                    le.method_6016((class_1291)data.get("effect"));
                } else {
                    le.method_6012();
                }
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("set_on_fire"), new SerializableData().add("duration", SerializableDataType.INT), (data, entity) -> entity.method_5639(data.getInt("duration"))));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("add_velocity"), new SerializableData().add("x", SerializableDataType.FLOAT, Float.valueOf(0.0f)).add("y", SerializableDataType.FLOAT, Float.valueOf(0.0f)).add("z", SerializableDataType.FLOAT, Float.valueOf(0.0f)).add("space", SerializableDataType.SPACE, Space.WORLD).add("set", SerializableDataType.BOOLEAN, false), (data, entity) -> {
            Space space = (Space)((Object)((Object)data.get("space")));
            class_1160 vec = new class_1160(data.getFloat("x"), data.getFloat("y"), data.getFloat("z"));
            TriConsumer method = (arg_0, arg_1, arg_2) -> ((class_1297)entity).method_5762(arg_0, arg_1, arg_2);
            if (data.getBoolean("set")) {
                method = (arg_0, arg_1, arg_2) -> ((class_1297)entity).method_18800(arg_0, arg_1, arg_2);
            }
            switch (space) {
                case WORLD: {
                    method.accept((Object)Float.valueOf(data.getFloat("x")), (Object)Float.valueOf(data.getFloat("y")), (Object)Float.valueOf(data.getFloat("z")));
                    break;
                }
                case LOCAL: {
                    Space.rotateVectorToBase(entity.method_5720(), vec);
                    method.accept((Object)Float.valueOf(vec.method_4943()), (Object)Float.valueOf(vec.method_4945()), (Object)Float.valueOf(vec.method_4947()));
                    break;
                }
                case LOCAL_HORIZONTAL: {
                    class_243 vel = entity.method_5720();
                    class_243 velH = new class_243(vel.field_1352, 0.0, vel.field_1350);
                    if (!(velH.method_1027() > 5.0E-5)) break;
                    velH = velH.method_1029();
                    Space.rotateVectorToBase(velH, vec);
                    method.accept((Object)Float.valueOf(vec.method_4943()), (Object)Float.valueOf(vec.method_4945()), (Object)Float.valueOf(vec.method_4947()));
                    break;
                }
                case VELOCITY: {
                    Space.rotateVectorToBase(entity.method_18798(), vec);
                    method.accept((Object)Float.valueOf(vec.method_4943()), (Object)Float.valueOf(vec.method_4945()), (Object)Float.valueOf(vec.method_4947()));
                    break;
                }
                case VELOCITY_NORMALIZED: {
                    Space.rotateVectorToBase(entity.method_18798().method_1029(), vec);
                    method.accept((Object)Float.valueOf(vec.method_4943()), (Object)Float.valueOf(vec.method_4945()), (Object)Float.valueOf(vec.method_4947()));
                    break;
                }
                case VELOCITY_HORIZONTAL: {
                    class_243 vel = entity.method_18798();
                    class_243 velH = new class_243(vel.field_1352, 0.0, vel.field_1350);
                    Space.rotateVectorToBase(velH, vec);
                    method.accept((Object)Float.valueOf(vec.method_4943()), (Object)Float.valueOf(vec.method_4945()), (Object)Float.valueOf(vec.method_4947()));
                    break;
                }
                case VELOCITY_HORIZONTAL_NORMALIZED: {
                    class_243 vel = entity.method_18798();
                    class_243 velH = new class_243(vel.field_1352, 0.0, vel.field_1350);
                    if (!(velH.method_1027() > 5.0E-5)) break;
                    velH = velH.method_1029();
                    Space.rotateVectorToBase(velH, vec);
                    method.accept((Object)Float.valueOf(vec.method_4943()), (Object)Float.valueOf(vec.method_4945()), (Object)Float.valueOf(vec.method_4947()));
                }
            }
            entity.field_6037 = true;
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("spawn_entity"), new SerializableData().add("entity_type", SerializableDataType.ENTITY_TYPE).add("tag", SerializableDataType.NBT, null).add("entity_action", SerializableDataType.ENTITY_ACTION, null), (data, entity) -> {
            class_1297 e = ((class_1299)data.get("entity_type")).method_5883(entity.field_6002);
            if (e != null) {
                e.method_5808(entity.method_19538().field_1352, entity.method_19538().field_1351, entity.method_19538().field_1350, entity.field_6031, entity.field_5965);
                if (data.isPresent("tag")) {
                    class_2487 mergedTag = e.method_5647(new class_2487());
                    mergedTag.method_10543((class_2487)data.get("tag"));
                    e.method_5651(mergedTag);
                }
                entity.field_6002.method_8649(e);
                if (data.isPresent("entity_action")) {
                    ((ActionFactory.Instance)data.get("entity_action")).accept(e);
                }
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("gain_air"), new SerializableData().add("value", SerializableDataType.INT), (data, entity) -> {
            if (entity instanceof class_1309) {
                class_1309 le = (class_1309)entity;
                le.method_5855(Math.min(le.method_5669() + data.getInt("value"), le.method_5748()));
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("block_action_at"), new SerializableData().add("block_action", SerializableDataType.BLOCK_ACTION), (data, entity) -> ((ActionFactory.Instance)data.get("block_action")).accept(Triple.of((Object)entity.field_6002, (Object)entity.method_24515(), (Object)class_2350.field_11036))));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("spawn_effect_cloud"), new SerializableData().add("radius", SerializableDataType.FLOAT, Float.valueOf(3.0f)).add("radius_on_use", SerializableDataType.FLOAT, Float.valueOf(-0.5f)).add("wait_time", SerializableDataType.INT, 10).add("effect", SerializableDataType.STATUS_EFFECT_INSTANCE, null).add("effects", SerializableDataType.STATUS_EFFECT_INSTANCES, null), (data, entity) -> {
            class_1295 areaEffectCloudEntity = new class_1295(entity.field_6002, entity.method_23317(), entity.method_23318(), entity.method_23321());
            if (entity instanceof class_1309) {
                areaEffectCloudEntity.method_5607((class_1309)entity);
            }
            areaEffectCloudEntity.method_5603(data.getFloat("radius"));
            areaEffectCloudEntity.method_5609(data.getFloat("radius_on_use"));
            areaEffectCloudEntity.method_5595(data.getInt("wait_time"));
            areaEffectCloudEntity.method_5596(-areaEffectCloudEntity.method_5599() / (float)areaEffectCloudEntity.method_5605());
            LinkedList<class_1293> effects = new LinkedList<class_1293>();
            if (data.isPresent("effect")) {
                effects.add((class_1293)data.get("effect"));
            }
            if (data.isPresent("effects")) {
                effects.addAll((List)data.get("effects"));
            }
            areaEffectCloudEntity.method_5602(class_1844.method_8055(effects));
            effects.forEach(arg_0 -> ((class_1295)areaEffectCloudEntity).method_5610(arg_0));
            entity.field_6002.method_8649((class_1297)areaEffectCloudEntity);
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("extinguish"), new SerializableData(), (data, entity) -> entity.method_5646()));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("execute_command"), new SerializableData().add("command", SerializableDataType.STRING).add("permission_level", SerializableDataType.INT, 4), (data, entity) -> {
            MinecraftServer server = entity.field_6002.method_8503();
            if (server != null) {
                class_2168 source = new class_2168(class_2165.field_17395, entity.method_19538(), entity.method_5802(), entity.field_6002 instanceof class_3218 ? (class_3218)entity.field_6002 : null, data.getInt("permission_level"), entity.method_5477().getString(), entity.method_5476(), entity.field_6002.method_8503(), entity);
                server.method_3734().method_9249(source, data.getString("command"));
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("change_resource"), new SerializableData().add("resource", SerializableDataType.POWER_TYPE).add("change", SerializableDataType.INT), (data, entity) -> {
            if (entity instanceof class_1657) {
                OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get(entity);
                Object p = component.getPower((PowerType)data.get("resource"));
                if (p instanceof VariableIntPower) {
                    VariableIntPower vip = (VariableIntPower)p;
                    int newValue = vip.getValue() + data.getInt("change");
                    vip.setValue(newValue);
                    OriginComponent.sync((class_1657)entity);
                } else if (p instanceof CooldownPower) {
                    CooldownPower cp = (CooldownPower)p;
                    cp.modify(data.getInt("change"));
                    OriginComponent.sync((class_1657)entity);
                }
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("feed"), new SerializableData().add("food", SerializableDataType.INT).add("saturation", SerializableDataType.FLOAT), (data, entity) -> {
            if (entity instanceof class_1657) {
                ((class_1657)entity).method_7344().method_7585(data.getInt("food"), data.getFloat("saturation"));
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("add_xp"), new SerializableData().add("points", SerializableDataType.INT, 0).add("levels", SerializableDataType.INT, 0), (data, entity) -> {
            if (entity instanceof class_1657) {
                int points = data.getInt("points");
                int levels = data.getInt("levels");
                if (points > 0) {
                    ((class_1657)entity).method_7255(points);
                }
                ((class_1657)entity).method_7316(levels);
            }
        }));
        Scheduler scheduler = new Scheduler();
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("delay"), new SerializableData().add("ticks", SerializableDataType.INT).add("action", SerializableDataType.ENTITY_ACTION), (data, entity) -> {
            ActionFactory.Instance action = (ActionFactory.Instance)data.get("action");
            scheduler.queue(s -> action.accept(entity), data.getInt("ticks"));
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("set_fall_distance"), new SerializableData().add("fall_distance", SerializableDataType.FLOAT), (data, entity) -> {
            entity.field_6017 = data.getFloat("fall_distance");
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("give"), new SerializableData().add("stack", SerializableDataType.ITEM_STACK), (data, entity) -> {
            if (!entity.field_6002.method_8608()) {
                class_1799 stack = (class_1799)data.get("stack");
                stack = stack.method_7972();
                if (entity instanceof class_1657) {
                    ((class_1657)entity).field_7514.method_7398(entity.field_6002, stack);
                } else {
                    entity.field_6002.method_8649((class_1297)new class_1542(entity.field_6002, entity.method_23317(), entity.method_23318(), entity.method_23321(), stack));
                }
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("equipped_item_action"), new SerializableData().add("equipment_slot", SerializableDataType.EQUIPMENT_SLOT).add("action", SerializableDataType.ITEM_ACTION), (data, entity) -> {
            if (entity instanceof class_1309) {
                class_1799 stack = ((class_1309)entity).method_6118((class_1304)data.get("equipment_slot"));
                ActionFactory.Instance action = (ActionFactory.Instance)data.get("action");
                action.accept(stack);
            }
        }));
        EntityActions.register(new ActionFactory<class_1297>(Origins.identifier("trigger_cooldown"), new SerializableData().add("power", SerializableDataType.POWER_TYPE), (data, entity) -> {
            OriginComponent component;
            Object p;
            if (entity instanceof class_1657 && (p = (component = (OriginComponent)ModComponents.ORIGIN.get(entity)).getPower((PowerType)data.get("power"))) instanceof CooldownPower) {
                CooldownPower cp = (CooldownPower)p;
                cp.use();
            }
        }));
    }

    private static void register(ActionFactory<class_1297> actionFactory) {
        class_2378.method_10230(ModRegistries.ENTITY_ACTION, (class_2960)actionFactory.getSerializerId(), actionFactory);
    }
}

