/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins;

import com.mojang.brigadier.CommandDispatcher;
import io.github.apace100.origins.OriginEventHandler;
import io.github.apace100.origins.command.LayerArgument;
import io.github.apace100.origins.command.OriginArgument;
import io.github.apace100.origins.command.OriginCommand;
import io.github.apace100.origins.command.PowerArgument;
import io.github.apace100.origins.command.PowerOperation;
import io.github.apace100.origins.command.ResourceCommand;
import io.github.apace100.origins.networking.ModPacketsC2S;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginManager;
import io.github.apace100.origins.power.PowerTypes;
import io.github.apace100.origins.power.factory.PowerFactories;
import io.github.apace100.origins.power.factory.action.BlockActions;
import io.github.apace100.origins.power.factory.action.EntityActions;
import io.github.apace100.origins.power.factory.action.ItemActions;
import io.github.apace100.origins.power.factory.condition.BiomeConditions;
import io.github.apace100.origins.power.factory.condition.BlockConditions;
import io.github.apace100.origins.power.factory.condition.DamageConditions;
import io.github.apace100.origins.power.factory.condition.EntityConditions;
import io.github.apace100.origins.power.factory.condition.FluidConditions;
import io.github.apace100.origins.power.factory.condition.ItemConditions;
import io.github.apace100.origins.registry.ModBlocks;
import io.github.apace100.origins.registry.ModEnchantments;
import io.github.apace100.origins.registry.ModEntities;
import io.github.apace100.origins.registry.ModItems;
import io.github.apace100.origins.registry.ModLoot;
import io.github.apace100.origins.registry.ModRecipes;
import io.github.apace100.origins.registry.ModTags;
import io.github.apace100.origins.util.ChoseOriginCriterion;
import io.github.apace100.origins.util.GainedPowerCriterion;
import io.github.apace100.origins.util.OriginsConfigSerializer;
import me.shedaniel.architectury.event.events.CommandRegistrationEvent;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.CriteriaTriggersRegistry;
import me.shedaniel.architectury.registry.ReloadListeners;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Origins {
    public static final String MODID = "origins";
    public static String VERSION = "";
    public static int[] SEMVER;
    public static final Logger LOGGER;
    public static ServerConfig config;

    public static void register() {
        String[] splitVersion = VERSION.split("\\.");
        SEMVER = new int[splitVersion.length];
        for (int i = 0; i < SEMVER.length; ++i) {
            Origins.SEMVER[i] = Integer.parseInt(splitVersion[i]);
        }
        LOGGER.info("Origins " + VERSION + " is initializing. Have fun!");
        AutoConfig.register(ServerConfig.class, OriginsConfigSerializer::new);
        config = (ServerConfig)AutoConfig.getConfigHolder(ServerConfig.class).getConfig();
        ModBlocks.register();
        ModItems.register();
        ModTags.register();
        ModPacketsC2S.register();
        ModEnchantments.register();
        ModEntities.register();
        ModLoot.registerLootTables();
        ModRecipes.register();
        PowerFactories.register();
        EntityConditions.register();
        ItemConditions.register();
        BlockConditions.register();
        DamageConditions.register();
        FluidConditions.register();
        BiomeConditions.register();
        EntityActions.register();
        ItemActions.register();
        BlockActions.register();
        Origin.init();
        OriginEventHandler.register();
        CommandRegistrationEvent.EVENT.register((dispatcher, dedicated) -> {
            OriginCommand.register((CommandDispatcher<CommandSource>)dispatcher);
            ResourceCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        });
        CriteriaTriggersRegistry.register((ICriterionTrigger)ChoseOriginCriterion.INSTANCE);
        CriteriaTriggersRegistry.register((ICriterionTrigger)GainedPowerCriterion.INSTANCE);
        ArgumentTypes.func_218136_a((String)"origins:origin", OriginArgument.class, (IArgumentSerializer)new ArgumentSerializer(OriginArgument::origin));
        ArgumentTypes.func_218136_a((String)"origins:layer", LayerArgument.class, (IArgumentSerializer)new ArgumentSerializer(LayerArgument::layer));
        ArgumentTypes.func_218136_a((String)"origins:power", PowerArgument.class, (IArgumentSerializer)new ArgumentSerializer(PowerArgument::power));
        ArgumentTypes.func_218136_a((String)"origins:power_operation", PowerOperation.class, (IArgumentSerializer)new ArgumentSerializer(PowerOperation::operation));
        ReloadListeners.registerReloadListener((ResourcePackType)ResourcePackType.SERVER_DATA, (IFutureReloadListener)new PowerTypes());
        ReloadListeners.registerReloadListener((ResourcePackType)ResourcePackType.SERVER_DATA, (IFutureReloadListener)new OriginManager());
        ReloadListeners.registerReloadListener((ResourcePackType)ResourcePackType.SERVER_DATA, (IFutureReloadListener)new OriginLayers());
    }

    public static ResourceLocation identifier(String path) {
        return new ResourceLocation(MODID, path);
    }

    static {
        LOGGER = LogManager.getLogger(Origins.class);
    }

    @Config(name="origins_server")
    public static class ServerConfig
    implements ConfigData {
        public boolean performVersionCheck = true;
        public boolean disableFoodRestrictions = Platform.isModLoaded((String)"diet");
    }
}

