/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins;

import io.github.apace100.origins.OriginClientEventHandler;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.networking.ModPacketsS2C;
import io.github.apace100.origins.power.Active;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.factory.condition.EntityConditionsClient;
import io.github.apace100.origins.registry.ModBlocks;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.github.apace100.origins.registry.ModEntities;
import io.github.apace100.origins.screen.GameHudRender;
import io.github.apace100.origins.screen.PowerHudRenderer;
import io.github.apace100.origins.screen.ViewOriginScreen;
import io.github.apace100.origins.util.OriginsConfigSerializer;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.registry.KeyBindings;
import me.shedaniel.architectury.registry.RenderTypes;
import me.shedaniel.architectury.registry.entity.EntityRenderers;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OriginsClient {
    public static KeyBinding usePrimaryActivePowerKeybind;
    public static KeyBinding useSecondaryActivePowerKeybind;
    public static KeyBinding viewCurrentOriginKeybind;
    public static ClientConfig config;
    public static boolean isServerRunningOrigins;
    private static HashMap<String, KeyBinding> idToKeyBindingMap;
    private static HashMap<String, Boolean> lastKeyBindingStates;
    private static boolean initializedKeyBindingMap;

    public static void registerPowerKeybinding(String keyId, KeyBinding keyBinding) {
        idToKeyBindingMap.put(keyId, keyBinding);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void register() {
        EntityRenderers.register(ModEntities.ENDERIAN_PEARL, dispatcher -> new SpriteRenderer(dispatcher, Minecraft.func_71410_x().func_175599_af()));
        ModPacketsS2C.register();
        EntityConditionsClient.register();
        OriginClientEventHandler.register();
        AutoConfig.register(ClientConfig.class, OriginsConfigSerializer::new);
        config = (ClientConfig)AutoConfig.getConfigHolder(ClientConfig.class).getConfig();
        usePrimaryActivePowerKeybind = new KeyBinding("key.origins.primary_active", InputMappings.Type.KEYSYM, 71, "category.origins");
        useSecondaryActivePowerKeybind = new KeyBinding("key.origins.secondary_active", InputMappings.Type.KEYSYM, -1, "category.origins");
        viewCurrentOriginKeybind = new KeyBinding("key.origins.view_origin", InputMappings.Type.KEYSYM, 79, "category.origins");
        OriginsClient.registerPowerKeybinding("key.origins.primary_active", usePrimaryActivePowerKeybind);
        OriginsClient.registerPowerKeybinding("key.origins.secondary_active", useSecondaryActivePowerKeybind);
        OriginsClient.registerPowerKeybinding("primary", usePrimaryActivePowerKeybind);
        OriginsClient.registerPowerKeybinding("secondary", useSecondaryActivePowerKeybind);
        KeyBindings.registerKeyBinding((KeyBinding)usePrimaryActivePowerKeybind);
        KeyBindings.registerKeyBinding((KeyBinding)useSecondaryActivePowerKeybind);
        KeyBindings.registerKeyBinding((KeyBinding)viewCurrentOriginKeybind);
        ClientTickEvent.CLIENT_PRE.register(tick -> {
            if (tick.field_71439_g != null) {
                List<Power> powers = ModComponentsArchitectury.getOriginComponent((Entity)tick.field_71439_g).getPowers();
                LinkedList<Power> pressedPowers = new LinkedList<Power>();
                HashMap<String, Boolean> currentKeyBindingStates = new HashMap<String, Boolean>();
                for (Power power : powers) {
                    if (!(power instanceof Active)) continue;
                    Active active = (Active)((Object)power);
                    Active.Key key = active.getKey();
                    KeyBinding keyBinding = OriginsClient.getKeyBinding(key.key);
                    if (keyBinding == null) continue;
                    if (!currentKeyBindingStates.containsKey(key.key)) {
                        currentKeyBindingStates.put(key.key, keyBinding.func_151470_d());
                    }
                    if (!((Boolean)currentKeyBindingStates.get(key.key)).booleanValue() || !key.continuous && lastKeyBindingStates.getOrDefault(key.key, false).booleanValue()) continue;
                    pressedPowers.add(power);
                }
                lastKeyBindingStates = currentKeyBindingStates;
                if (pressedPowers.size() > 0) {
                    OriginsClient.performActivePowers(pressedPowers);
                }
            }
            while (viewCurrentOriginKeybind.func_151468_f()) {
                if (Minecraft.func_71410_x().field_71462_r instanceof ViewOriginScreen) continue;
                Minecraft.func_71410_x().func_147108_a((Screen)new ViewOriginScreen());
            }
        });
        GameHudRender.HUD_RENDERS.add(new PowerHudRenderer());
    }

    public static void setup() {
        RenderTypes.register((RenderType)RenderType.func_228643_e_(), (Block[])new Block[]{ModBlocks.TEMPORARY_COBWEB});
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void performActivePowers(List<Power> powers) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.writeInt(powers.size());
        for (Power power : powers) {
            buffer.func_192572_a(power.getType().getIdentifier());
            ((Active)((Object)power)).onUse();
        }
        NetworkManager.sendToServer((ResourceLocation)ModPackets.USE_ACTIVE_POWERS, (PacketBuffer)buffer);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static KeyBinding getKeyBinding(String key) {
        if (!idToKeyBindingMap.containsKey(key)) {
            if (!initializedKeyBindingMap) {
                initializedKeyBindingMap = true;
                Minecraft client = Minecraft.func_71410_x();
                for (int i = 0; i < client.field_71474_y.field_74324_K.length; ++i) {
                    idToKeyBindingMap.put(client.field_71474_y.field_74324_K[i].func_151464_g(), client.field_71474_y.field_74324_K[i]);
                }
                return OriginsClient.getKeyBinding(key);
            }
            return null;
        }
        return idToKeyBindingMap.get(key);
    }

    static {
        isServerRunningOrigins = false;
        idToKeyBindingMap = new HashMap();
        lastKeyBindingStates = new HashMap();
        initializedKeyBindingMap = false;
    }

    @Config(name="origins")
    public static class ClientConfig
    implements ConfigData {
        public int xOffset = 0;
        public int yOffset = 0;
        @ConfigEntry.BoundedDiscrete(max=1L)
        public float phantomizedOverlayStrength = 0.8f;

        public void validatePostLoad() {
            if (this.phantomizedOverlayStrength < 0.0f) {
                this.phantomizedOverlayStrength = 0.0f;
            } else if (this.phantomizedOverlayStrength > 1.0f) {
                this.phantomizedOverlayStrength = 1.0f;
            }
        }
    }
}

