/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.OriginsClient;
import io.github.apace100.origins.OriginsForgeClient;
import io.github.apace100.origins.OriginsServer;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.registry.forge.ModComponentsArchitecturyImpl;
import java.util.Arrays;
import java.util.function.Predicate;
import me.shedaniel.architectury.platform.forge.EventBuses;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.maven.artifact.versioning.ArtifactVersion;

@Mod(value="origins")
public class OriginsForge {
    public static boolean SHOULD_QUEUE_SCREEN = false;
    private static final String NETVERSION = "0.7.1.4";
    public static final SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)Origins.identifier("handshake"), () -> "0.7.1.4", (Predicate)NetworkRegistry.acceptMissingOr((String)"0.7.1.4"), (Predicate)NetworkRegistry.acceptMissingOr((String)"0.7.1.4"));

    public OriginsForge() {
        ArtifactVersion version = ModLoadingContext.get().getActiveContainer().getModInfo().getVersion();
        Origins.VERSION = version.toString();
        EventBuses.registerModEventBus((String)"origins", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        Origins.register();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> OriginsForgeClient::initialize);
        DistExecutor.safeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> OriginsServer::register);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> CapabilityManager.INSTANCE.register(OriginComponent.class, (Capability.IStorage)new ModComponentsArchitecturyImpl.OriginStorage(), () -> null));
        MinecraftForge.EVENT_BUS.addListener(event -> {
            OriginsClient.isServerRunningOrigins = true;
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            OriginsClient.isServerRunningOrigins = false;
        });
    }

    private static boolean isRemoteValid(String remote) {
        if (NetworkRegistry.ABSENT.equals(remote)) {
            return true;
        }
        if (NetworkRegistry.ACCEPTVANILLA.equals(remote)) {
            return true;
        }
        try {
            int[] ints = Arrays.stream(remote.split("\\.")).mapToInt(Integer::parseInt).toArray();
            if (ints.length == 0) {
                Origins.LOGGER.warn("Remote version couldn't be established: {}", (Object)remote);
                return false;
            }
            if (ints.length == 1) {
                return Origins.SEMVER.length == 1 && ints[0] == Origins.SEMVER[0];
            }
            boolean minor = ints[0] == Origins.SEMVER[0] && ints[1] == Origins.SEMVER[2];
            boolean build = true;
            return minor && build;
        }
        catch (NumberFormatException e) {
            Origins.LOGGER.warn("Remote isn't using SemVer, probably a newer version: {}", (Object)remote);
            return false;
        }
    }
}

