/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.apace100.origins.command.LayerArgument;
import io.github.apace100.origins.command.OriginArgument;
import io.github.apace100.origins.command.PowerArgument;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class OriginCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"origin").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"layer", (ArgumentType)LayerArgument.layer()).then(Commands.func_197056_a((String)"origin", (ArgumentType)OriginArgument.origin()).executes(command -> {
            int i = 0;
            Collection targets = EntityArgument.func_197090_e((CommandContext)command, (String)"targets");
            OriginLayer l = (OriginLayer)command.getArgument("layer", OriginLayer.class);
            Origin o = (Origin)command.getArgument("origin", Origin.class);
            for (ServerPlayerEntity target : targets) {
                OriginCommand.setOrigin((PlayerEntity)target, l, o);
                ++i;
            }
            if (targets.size() == 1) {
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.origin.set.success.single", new Object[]{((ServerPlayerEntity)targets.iterator().next()).func_145748_c_(), new TranslationTextComponent(l.getTranslationKey()), o.getName()}), true);
            } else {
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.origin.set.success.multiple", new Object[]{targets.size(), new TranslationTextComponent(l.getTranslationKey()), o.getName()}), true);
            }
            return i;
        })))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"has").then(Commands.func_197057_a((String)"origin").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"layer", (ArgumentType)LayerArgument.layer()).then(Commands.func_197056_a((String)"origin", (ArgumentType)OriginArgument.origin()).executes(command -> {
            int i = 0;
            Collection targets = EntityArgument.func_197090_e((CommandContext)command, (String)"targets");
            OriginLayer l = (OriginLayer)command.getArgument("layer", OriginLayer.class);
            Origin o = (Origin)command.getArgument("origin", Origin.class);
            for (ServerPlayerEntity target : targets) {
                if (!OriginCommand.hasOrigin((PlayerEntity)target, l, o)) continue;
                ++i;
            }
            if (i == 0) {
                ((CommandSource)command.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("commands.execute.conditional.fail"));
            } else if (targets.size() == 1) {
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.execute.conditional.pass"), false);
            } else {
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.execute.conditional.pass_count", new Object[]{i}), false);
            }
            return i;
        })))))).then(Commands.func_197057_a((String)"power").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"power", (ArgumentType)PowerArgument.power()).executes(command -> {
            int i = 0;
            Collection targets = EntityArgument.func_197090_e((CommandContext)command, (String)"targets");
            PowerType powerType = (PowerType)command.getArgument("power", PowerType.class);
            for (ServerPlayerEntity target : targets) {
                if (!OriginCommand.hasPower((PlayerEntity)target, powerType)) continue;
                ++i;
            }
            if (i == 0) {
                ((CommandSource)command.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("commands.execute.conditional.fail"));
            } else if (targets.size() == 1) {
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.execute.conditional.pass"), false);
            } else {
                ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.execute.conditional.pass_count", new Object[]{i}), false);
            }
            return i;
        })))))).then(Commands.func_197057_a((String)"get").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"layer", (ArgumentType)LayerArgument.layer()).executes(command -> {
            ServerPlayerEntity target = EntityArgument.func_197089_d((CommandContext)command, (String)"target");
            OriginLayer layer = (OriginLayer)command.getArgument("layer", OriginLayer.class);
            OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)target);
            Origin origin = component.getOrigin(layer);
            ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.origin.get.result", new Object[]{target.func_145748_c_(), new TranslationTextComponent(layer.getTranslationKey()), origin.getName(), origin.getIdentifier()}), false);
            return 1;
        })))));
    }

    private static void setOrigin(PlayerEntity player, OriginLayer layer, Origin origin) {
        OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)player);
        component.setOrigin(layer, origin);
        OriginComponent.sync(player);
        boolean hadOriginBefore = component.hadOriginBefore();
        origin.getPowerTypes().forEach(powerType -> ((Power)component.getPower(powerType)).onChosen(hadOriginBefore));
    }

    private static boolean hasOrigin(PlayerEntity player, OriginLayer layer, Origin origin) {
        OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)player);
        return component.hasOrigin(layer) && component.getOrigin(layer).equals(origin);
    }

    private static boolean hasPower(PlayerEntity player, PowerType<?> powerType) {
        return ModComponentsArchitectury.getOriginComponent((Entity)player).hasPower(powerType);
    }
}

