/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.origins.command.PowerArgument;
import io.github.apace100.origins.command.PowerOperation;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.CooldownPower;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.VariableIntPower;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ObjectiveArgument;
import net.minecraft.command.arguments.ScoreHolderArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.scoreboard.Score;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ResourceCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"resource").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197057_a((String)"has").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"power", (ArgumentType)PowerArgument.power()).executes(command -> ResourceCommand.resource((CommandContext<CommandSource>)command, Subcommands.HAS)))))).then(Commands.func_197057_a((String)"get").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"power", (ArgumentType)PowerArgument.power()).executes(command -> ResourceCommand.resource((CommandContext<CommandSource>)command, Subcommands.GET)))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"power", (ArgumentType)PowerArgument.power()).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(command -> ResourceCommand.resource((CommandContext<CommandSource>)command, Subcommands.SET))))))).then(Commands.func_197057_a((String)"change").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"power", (ArgumentType)PowerArgument.power()).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(command -> ResourceCommand.resource((CommandContext<CommandSource>)command, Subcommands.CHANGE))))))).then(Commands.func_197057_a((String)"operation").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"power", (ArgumentType)PowerArgument.power()).then(Commands.func_197056_a((String)"operation", (ArgumentType)PowerOperation.operation()).then(Commands.func_197056_a((String)"entity", (ArgumentType)ScoreHolderArgument.func_197209_a()).then(Commands.func_197056_a((String)"objective", (ArgumentType)ObjectiveArgument.func_197157_a()).executes(command -> ResourceCommand.resource((CommandContext<CommandSource>)command, Subcommands.OPERATION)))))))));
    }

    private static int resource(CommandContext<CommandSource> command, Subcommands sub) throws CommandSyntaxException {
        int i = 0;
        ServerPlayerEntity player = EntityArgument.func_197089_d(command, (String)"target");
        PowerType powerType = (PowerType)command.getArgument("power", PowerType.class);
        Object power = ModComponentsArchitectury.getOriginComponent((Entity)player).getPower(powerType);
        if (power instanceof VariableIntPower) {
            VariableIntPower vIntPower = (VariableIntPower)power;
            switch (sub) {
                case HAS: {
                    ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.execute.conditional.pass"), true);
                    return 1;
                }
                case GET: {
                    i = vIntPower.getValue();
                    ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.scoreboard.players.get.success", new Object[]{player.func_195047_I_(), i, powerType.getIdentifier()}), true);
                    return i;
                }
                case SET: {
                    i = IntegerArgumentType.getInteger(command, (String)"value");
                    vIntPower.setValue(i);
                    OriginComponent.sync((PlayerEntity)player);
                    ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.scoreboard.players.set.success.single", new Object[]{powerType.getIdentifier(), player.func_195047_I_(), i}), true);
                    return 1;
                }
                case CHANGE: {
                    i = IntegerArgumentType.getInteger(command, (String)"value");
                    int total = vIntPower.getValue() + i;
                    vIntPower.setValue(total);
                    OriginComponent.sync((PlayerEntity)player);
                    ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.scoreboard.players.add.success.single", new Object[]{i, powerType.getIdentifier(), player.func_195047_I_(), total}), true);
                    return 1;
                }
                case OPERATION: {
                    Score score = ((CommandSource)command.getSource()).func_197028_i().func_200251_aP().func_96529_a(ScoreHolderArgument.func_197211_a(command, (String)"entity"), ObjectiveArgument.func_197158_a(command, (String)"objective"));
                    ((PowerOperation.Operation)command.getArgument("operation", PowerOperation.Operation.class)).apply(vIntPower, score);
                    OriginComponent.sync((PlayerEntity)player);
                    ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.scoreboard.players.operation.success.single", new Object[]{powerType.getIdentifier(), player.func_195047_I_(), vIntPower.getValue()}), true);
                    return 1;
                }
            }
        } else if (power instanceof CooldownPower) {
            CooldownPower cooldownPower = (CooldownPower)power;
            switch (sub) {
                case HAS: {
                    ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.execute.conditional.pass"), true);
                    return 1;
                }
                case GET: {
                    i = cooldownPower.getRemainingTicks();
                    ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.scoreboard.players.get.success", new Object[]{player.func_195047_I_(), i, powerType.getIdentifier()}), true);
                    return i;
                }
                case SET: {
                    i = IntegerArgumentType.getInteger(command, (String)"value");
                    cooldownPower.setCooldown(i);
                    OriginComponent.sync((PlayerEntity)player);
                    ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.scoreboard.players.set.success.single", new Object[]{powerType.getIdentifier(), player.func_195047_I_(), i}), true);
                    return 1;
                }
                case CHANGE: {
                    i = IntegerArgumentType.getInteger(command, (String)"value");
                    cooldownPower.modify(i);
                    OriginComponent.sync((PlayerEntity)player);
                    ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.scoreboard.players.add.success.single", new Object[]{i, powerType.getIdentifier(), player.func_195047_I_(), cooldownPower.getRemainingTicks()}), true);
                    return 1;
                }
                case OPERATION: {
                    Score score = ((CommandSource)command.getSource()).func_197028_i().func_200251_aP().func_96529_a(ScoreHolderArgument.func_197211_a(command, (String)"entity"), ObjectiveArgument.func_197158_a(command, (String)"objective"));
                    ((PowerOperation.Operation)command.getArgument("operation", PowerOperation.Operation.class)).apply(cooldownPower, score);
                    OriginComponent.sync((PlayerEntity)player);
                    ((CommandSource)command.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.scoreboard.players.operation.success.single", new Object[]{powerType.getIdentifier(), player.func_195047_I_(), cooldownPower.getRemainingTicks()}), true);
                    return 1;
                }
            }
        } else {
            switch (sub) {
                case HAS: {
                    ((CommandSource)command.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("commands.execute.conditional.fail"));
                    return 0;
                }
                case GET: {
                    ((CommandSource)command.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("commands.scoreboard.players.get.null", new Object[]{powerType.getIdentifier(), player.func_195047_I_()}));
                    return 0;
                }
                case SET: 
                case CHANGE: 
                case OPERATION: {
                    ((CommandSource)command.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("argument.scoreHolder.empty"));
                    return 0;
                }
            }
        }
        return 0;
    }

    public static enum Subcommands {
        HAS,
        GET,
        SET,
        CHANGE,
        OPERATION;

    }
}

