/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.component;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeRegistry;
import io.github.apace100.origins.power.SimpleStatusEffectPower;
import io.github.apace100.origins.power.StackingStatusEffectPower;
import io.github.apace100.origins.power.StatusEffectPower;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class PlayerOriginComponent
implements OriginComponent {
    private final PlayerEntity player;
    private final HashMap<OriginLayer, Origin> origins = new HashMap();
    private final ConcurrentHashMap<PowerType<?>, Power> powers = new ConcurrentHashMap();
    private boolean hadOriginBefore = false;

    public PlayerOriginComponent(PlayerEntity player) {
        this.player = player;
    }

    @Override
    public boolean hasAllOrigins() {
        return OriginLayers.getLayers().stream().allMatch(layer -> !layer.isEnabled() || layer.getOrigins(this.player).size() == 0 || this.origins.containsKey(layer) && this.origins.get(layer) != null && this.origins.get(layer) != Origin.EMPTY);
    }

    @Override
    public HashMap<OriginLayer, Origin> getOrigins() {
        return this.origins;
    }

    @Override
    public boolean hasOrigin(OriginLayer layer) {
        return this.origins.containsKey(layer) && this.origins.get(layer) != null && this.origins.get(layer) != Origin.EMPTY;
    }

    @Override
    public Origin getOrigin(OriginLayer layer) {
        if (!this.origins.containsKey(layer)) {
            return null;
        }
        return this.origins.get(layer);
    }

    @Override
    public boolean hadOriginBefore() {
        return this.hadOriginBefore;
    }

    @Override
    public boolean hasPower(PowerType<?> powerType) {
        return this.powers.containsKey(powerType);
    }

    private boolean hasPowerType(PowerType<?> powerType) {
        return this.origins.values().stream().anyMatch(o -> o.hasPowerType(powerType));
    }

    @Override
    public <T extends Power> T getPower(PowerType<T> powerType) {
        if (this.powers.containsKey(powerType)) {
            return (T)this.powers.get(powerType);
        }
        return null;
    }

    @Override
    public List<Power> getPowers() {
        return new LinkedList<Power>(this.powers.values());
    }

    private Set<PowerType<?>> getPowerTypes() {
        HashSet powerTypes = new HashSet();
        this.origins.values().forEach(origin -> {
            if (origin != null) {
                origin.getPowerTypes().forEach(powerTypes::add);
            }
        });
        return powerTypes;
    }

    @Override
    public <T extends Power> List<T> getPowers(Class<T> powerClass) {
        return this.getPowers(powerClass, false);
    }

    @Override
    public <T extends Power> List<T> getPowers(Class<T> powerClass, boolean includeInactive) {
        LinkedList<Power> list = new LinkedList<Power>();
        for (Power power : this.powers.values()) {
            if (!powerClass.isAssignableFrom(power.getClass()) || !includeInactive && !power.isActive()) continue;
            list.add((Power)powerClass.cast(power));
        }
        return list;
    }

    @Override
    public void setOrigin(OriginLayer layer, Origin origin) {
        Origin oldOrigin = this.getOrigin(layer);
        if (oldOrigin == origin) {
            return;
        }
        this.origins.put(layer, origin);
        if (oldOrigin != null) {
            LinkedList powersToRemove = new LinkedList();
            for (Map.Entry<PowerType<?>, Power> entry : this.powers.entrySet()) {
                if (this.hasPowerType(entry.getKey())) continue;
                entry.getValue().onRemoved();
                entry.getValue().onLost();
                powersToRemove.add(entry.getKey());
            }
            for (PowerType powerType2 : powersToRemove) {
                this.powers.remove(powerType2);
            }
        }
        origin.getPowerTypes().forEach(powerType -> {
            if (!this.powers.containsKey(powerType)) {
                Object power = powerType.create(this.player);
                this.powers.put((PowerType<?>)powerType, (Power)power);
                ((Power)power).onAdded();
            }
        });
        if (this.hasAllOrigins()) {
            this.hadOriginBefore = true;
        }
    }

    @Override
    public void serverTick() {
        this.getPowers(Power.class, true).stream().filter(p -> p.shouldTick() && (p.shouldTickWhenInactive() || p.isActive())).forEach(Power::tick);
        if (this.player.field_70173_aa % 10 == 0) {
            this.getPowers(SimpleStatusEffectPower.class).forEach(StatusEffectPower::applyEffects);
            this.getPowers(StackingStatusEffectPower.class, true).forEach(StackingStatusEffectPower::tick);
        }
    }

    @Override
    public void readFromNbt(CompoundNBT compoundTag) {
        this.fromTag(compoundTag, true);
    }

    private void fromTag(CompoundNBT compoundTag, boolean callPowerOnAdd) {
        if (this.player == null) {
            Origins.LOGGER.error("Player was null in `fromTag`! This is a bug!");
        }
        if (this.origins != null) {
            if (callPowerOnAdd) {
                for (Power power : this.powers.values()) {
                    power.onRemoved();
                    power.onLost();
                }
            }
            this.powers.clear();
        }
        this.origins.clear();
        if (compoundTag.func_74764_b("Origin")) {
            try {
                OriginLayer defaultOriginLayer = OriginLayers.getLayer(new ResourceLocation("origins", "origin"));
                this.origins.put(defaultOriginLayer, OriginRegistry.get(ResourceLocation.func_208304_a((String)compoundTag.func_74779_i("Origin"))));
            }
            catch (IllegalArgumentException e) {
                Origins.LOGGER.warn("Player " + this.player.func_145748_c_().func_150261_e() + " had old origin which could not be migrated: " + compoundTag.func_74779_i("Origin"));
            }
        } else {
            ListNBT originLayerList = (ListNBT)compoundTag.func_74781_a("OriginLayers");
            if (originLayerList != null) {
                for (int i = 0; i < originLayerList.size(); ++i) {
                    CompoundNBT layerTag = originLayerList.func_150305_b(i);
                    ResourceLocation layerId = ResourceLocation.func_208304_a((String)layerTag.func_74779_i("Layer"));
                    OriginLayer layer = null;
                    try {
                        layer = OriginLayers.getLayer(layerId);
                    }
                    catch (IllegalArgumentException e) {
                        Origins.LOGGER.warn("Could not find origin layer with id " + layerId + ", which existed on the data of player " + this.player.func_145748_c_().func_150261_e() + ".");
                    }
                    if (layer == null) continue;
                    ResourceLocation originId = ResourceLocation.func_208304_a((String)layerTag.func_74779_i("Origin"));
                    Origin origin = null;
                    try {
                        origin = OriginRegistry.get(originId);
                    }
                    catch (IllegalArgumentException e) {
                        Origins.LOGGER.warn("Could not find origin with id " + originId + ", which existed on the data of player " + this.player.func_145748_c_().func_150261_e() + ".");
                    }
                    if (origin == null) continue;
                    if (!layer.contains(origin) && !origin.isSpecial()) {
                        Origins.LOGGER.warn("Origin with id " + origin.getIdentifier().toString() + " is not in layer " + layer.getIdentifier().toString() + " and is not special, but was found on " + this.player.func_145748_c_().func_150261_e() + ", setting to EMPTY.");
                        origin = Origin.EMPTY;
                    }
                    this.origins.put(layer, origin);
                }
            }
        }
        this.hadOriginBefore = compoundTag.func_74767_n("HadOriginBefore");
        ListNBT powerList = compoundTag.func_150295_c("Powers", 10);
        for (int i = 0; i < powerList.size(); ++i) {
            CompoundNBT powerTag = powerList.func_150305_b(i);
            ResourceLocation powerTypeId = ResourceLocation.func_208304_a((String)powerTag.func_74779_i("Type"));
            try {
                PowerType type = PowerTypeRegistry.get(powerTypeId);
                if (!this.hasPowerType(type)) continue;
                INBT data = powerTag.func_74781_a("Data");
                Object power = type.create(this.player);
                try {
                    ((Power)power).fromTag(data);
                }
                catch (ClassCastException e) {
                    Origins.LOGGER.warn("Data type of \"" + powerTypeId + "\" changed, skipping data for that power on player " + this.player.func_200200_C_().func_150261_e());
                }
                this.powers.put(type, (Power)power);
                if (!callPowerOnAdd) continue;
                ((Power)power).onAdded();
                continue;
            }
            catch (IllegalArgumentException e) {
                Origins.LOGGER.warn("Power data of unregistered power \"" + powerTypeId + "\" found on player, skipping...");
            }
        }
        this.getPowerTypes().forEach(pt -> {
            if (!this.powers.containsKey(pt)) {
                Object power = pt.create(this.player);
                this.powers.put((PowerType<?>)pt, (Power)power);
            }
        });
    }

    @Override
    public void writeToNbt(CompoundNBT compoundTag) {
        ListNBT originLayerList = new ListNBT();
        for (Map.Entry<OriginLayer, Origin> entry : this.origins.entrySet()) {
            CompoundNBT layerTag = new CompoundNBT();
            layerTag.func_74778_a("Layer", entry.getKey().getIdentifier().toString());
            layerTag.func_74778_a("Origin", entry.getValue().getIdentifier().toString());
            originLayerList.add((Object)layerTag);
        }
        compoundTag.func_218657_a("OriginLayers", (INBT)originLayerList);
        compoundTag.func_74757_a("HadOriginBefore", this.hadOriginBefore);
        ListNBT powerList = new ListNBT();
        for (Map.Entry<PowerType<?>, Power> powerEntry : this.powers.entrySet()) {
            CompoundNBT powerTag = new CompoundNBT();
            powerTag.func_74778_a("Type", PowerTypeRegistry.getId(powerEntry.getKey()).toString());
            powerTag.func_218657_a("Data", powerEntry.getValue().toTag());
            powerList.add((Object)powerTag);
        }
        compoundTag.func_218657_a("Powers", (INBT)powerList);
    }

    @Override
    public void applySyncPacket(PacketBuffer buf) {
        CompoundNBT compoundTag = buf.func_150793_b();
        if (compoundTag != null) {
            this.fromTag(compoundTag, false);
        }
    }

    @Override
    public void sync() {
        OriginComponent.sync(this.player);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("OriginComponent[\n");
        for (Map.Entry<PowerType<?>, Power> powerEntry : this.powers.entrySet()) {
            str.append("\t").append(PowerTypeRegistry.getId(powerEntry.getKey())).append(": ").append(powerEntry.getValue().toTag().toString()).append("\n");
        }
        str.append("]");
        return str.toString();
    }
}

