/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.PreventEntityRenderPower;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={EntityRendererManager.class})
public class EntityRenderDispatcherMixin {
    @Inject(method={"shouldRender"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventRenderingEntities(Entity entity, ClippingHelper frustum, double x, double y, double z, CallbackInfoReturnable<Boolean> cir) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && OriginComponent.getPowers((Entity)player, PreventEntityRenderPower.class).stream().anyMatch(perp -> perp.doesApply(entity))) {
            cir.setReturnValue((Object)false);
        }
    }
}

