/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.power.ModifyFoodPower;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.github.apace100.origins.util.AttributeUtil;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FoodStats.class})
public class HungerManagerMixin {
    @Unique
    private PlayerEntity player;

    @Redirect(method={"eat"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/FoodComponent;getHunger()I"))
    private int modifyHunger(Food foodComponent, Item item, ItemStack stack) {
        if (this.player != null) {
            double baseValue = foodComponent.func_221466_a();
            List<AttributeModifier> modifiers = ModComponentsArchitectury.getOriginComponent((Entity)this.player).getPowers(ModifyFoodPower.class).stream().filter(p -> p.doesApply(stack)).flatMap(p -> p.getFoodModifiers().stream()).collect(Collectors.toList());
            return (int)AttributeUtil.sortAndApplyModifiers(modifiers, baseValue);
        }
        return foodComponent.func_221466_a();
    }

    @Redirect(method={"eat"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/FoodComponent;getSaturationModifier()F"))
    private float modifySaturation(Food foodComponent, Item item, ItemStack stack) {
        if (this.player != null) {
            double baseValue = foodComponent.func_221469_b();
            List<AttributeModifier> modifiers = ModComponentsArchitectury.getOriginComponent((Entity)this.player).getPowers(ModifyFoodPower.class).stream().filter(p -> p.doesApply(stack)).flatMap(p -> p.getSaturationModifiers().stream()).collect(Collectors.toList());
            return (float)AttributeUtil.sortAndApplyModifiers(modifiers, baseValue);
        }
        return foodComponent.func_221469_b();
    }

    @Inject(method={"eat"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/HungerManager;add(IF)V", shift=At.Shift.AFTER)})
    private void executeAdditionalEatAction(Item item, ItemStack stack, CallbackInfo ci) {
        if (this.player != null) {
            ModComponentsArchitectury.getOriginComponent((Entity)this.player).getPowers(ModifyFoodPower.class).stream().filter(p -> p.doesApply(stack)).forEach(ModifyFoodPower::eat);
        }
    }

    @Inject(method={"update"}, at={@At(value="HEAD")})
    private void cachePlayer(PlayerEntity player, CallbackInfo ci) {
        this.player = player;
    }
}

