/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.ActionOnItemUsePower;
import io.github.apace100.origins.power.PreventItemUsePower;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Unique
    private ItemStack usedItemStack;

    @Inject(at={@At(value="HEAD")}, method={"use"}, cancellable=true)
    public void use(World world, PlayerEntity user, Hand hand, CallbackInfoReturnable<ActionResult<ItemStack>> info) {
        if (user != null) {
            OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)user);
            ItemStack stackInHand = user.func_184586_b(hand);
            for (PreventItemUsePower piup : component.getPowers(PreventItemUsePower.class)) {
                if (!piup.doesPrevent(stackInHand)) continue;
                info.setReturnValue((Object)ActionResult.func_226251_d_((Object)stackInHand));
                break;
            }
        }
    }

    @Inject(method={"finishUsing"}, at={@At(value="HEAD")})
    public void cacheUsedItemStack(World world, LivingEntity user, CallbackInfoReturnable<ItemStack> cir) {
        this.usedItemStack = ((ItemStack)this).func_77946_l();
    }

    @Inject(method={"finishUsing"}, at={@At(value="RETURN")})
    public void callActionOnUse(World world, LivingEntity user, CallbackInfoReturnable<ItemStack> cir) {
        if (user instanceof PlayerEntity) {
            ItemStack returnStack = (ItemStack)cir.getReturnValue();
            OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)user);
            for (ActionOnItemUsePower p : component.getPowers(ActionOnItemUsePower.class)) {
                if (!p.doesApply(this.usedItemStack)) continue;
                p.executeActions(returnStack);
            }
        }
    }
}

