/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.access.EndRespawningEntity;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.ModifyPlayerSpawnPower;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerList.class})
public abstract class LoginMixin {
    @Redirect(method={"respawnPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;setSpawnPoint(Lnet/minecraft/util/registry/RegistryKey;Lnet/minecraft/util/math/BlockPos;FZZ)V"))
    private void preventEndExitSpawnPointSetting(ServerPlayerEntity serverPlayerEntity, RegistryKey<World> dimension, BlockPos pos, float angle, boolean spawnPointSet, boolean bl, ServerPlayerEntity playerEntity, boolean alive) {
        EndRespawningEntity ere = (EndRespawningEntity)playerEntity;
        if (ere.hasRealRespawnPoint()) {
            serverPlayerEntity.func_242111_a(dimension, pos, angle, spawnPointSet, bl);
        }
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    private void invokeOnRemovedCallback(ServerPlayerEntity player, CallbackInfo ci) {
        OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)player);
        component.getPowers().forEach(Power::onRemoved);
    }

    @Redirect(method={"respawnPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;findRespawnPosition(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;FZZ)Ljava/util/Optional;"))
    private Optional<Vector3d> retryObstructedSpawnpointIfFailed(ServerWorld world, BlockPos pos, float f, boolean bl, boolean bl2, ServerPlayerEntity player, boolean alive) {
        Optional original = PlayerEntity.func_242374_a((ServerWorld)world, (BlockPos)pos, (float)f, (boolean)bl, (boolean)bl2);
        if (!original.isPresent() && OriginComponent.hasPower((Entity)player, ModifyPlayerSpawnPower.class)) {
            return Optional.ofNullable(TransportationHelper.func_242379_a((EntityType)EntityType.field_200729_aH, (ICollisionReader)world, (BlockPos)pos, (boolean)bl));
        }
        return original;
    }

    @Inject(method={"respawnPlayer"}, at={@At(value="HEAD")})
    private void invokePowerRemovedCallback(ServerPlayerEntity player, boolean alive, CallbackInfoReturnable<ServerPlayerEntity> cir) {
        List<Power> powers = ModComponentsArchitectury.getOriginComponent((Entity)player).getPowers();
        powers.forEach(Power::onRemoved);
    }
}

