/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin.forge;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.LavaVisionPower;
import io.github.apace100.origins.power.PhasingPower;
import io.github.apace100.origins.util.ClientHooks;
import java.util.List;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.entity.player.PlayerEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={FogRenderer.class})
public class BackgroundRendererMixin {
    @Redirect(method={"setupFog"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;fogStart(F)V"), remap=false)
    private static void redirectFogStart(float start, ActiveRenderInfo camera, FogRenderer.FogType fogType) {
        List<PhasingPower> phasings;
        if (camera.func_216773_g() instanceof PlayerEntity && (phasings = OriginComponent.getPowers(camera.func_216773_g(), PhasingPower.class)).stream().anyMatch(pp -> pp.getRenderType() == PhasingPower.RenderType.BLINDNESS) && ClientHooks.getInWallBlockState((PlayerEntity)camera.func_216773_g()) != null) {
            float view = phasings.stream().filter(pp -> pp.getRenderType() == PhasingPower.RenderType.BLINDNESS).map(PhasingPower::getViewDistance).min(Float::compareTo).orElseThrow(RuntimeException::new).floatValue();
            float s = fogType == FogRenderer.FogType.FOG_SKY ? Math.min(0.0f, start) : Math.min(view * 0.25f, start);
            RenderSystem.fogStart((float)s);
            return;
        }
        RenderSystem.fogStart((float)start);
    }

    @Redirect(method={"setupFog"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;fogEnd(F)V"), remap=false)
    private static void redirectFogEnd(float end, ActiveRenderInfo camera, FogRenderer.FogType fogType) {
        List<PhasingPower> phasings;
        if (camera.func_216773_g() instanceof PlayerEntity && (phasings = OriginComponent.getPowers(camera.func_216773_g(), PhasingPower.class)).stream().anyMatch(pp -> pp.getRenderType() == PhasingPower.RenderType.BLINDNESS) && ClientHooks.getInWallBlockState((PlayerEntity)camera.func_216773_g()) != null) {
            float view = phasings.stream().filter(pp -> pp.getRenderType() == PhasingPower.RenderType.BLINDNESS).map(PhasingPower::getViewDistance).min(Float::compareTo).orElseThrow(RuntimeException::new).floatValue();
            float v = fogType == FogRenderer.FogType.FOG_SKY ? Math.min(view * 0.8f, end) : Math.min(view, end);
            RenderSystem.fogEnd((float)v);
            return;
        }
        RenderSystem.fogEnd((float)end);
    }

    @ModifyConstant(method={"setupFog"}, constant={@Constant(floatValue=0.25f, ordinal=0)}, remap=false)
    private static float modifyLavaVisibilitySNoPotion(float original, ActiveRenderInfo camera) {
        List<LavaVisionPower> powers = OriginComponent.getPowers(camera.func_216773_g(), LavaVisionPower.class);
        if (powers.size() > 0) {
            return powers.get(0).getS();
        }
        return original;
    }

    @ModifyConstant(method={"setupFog"}, constant={@Constant(floatValue=1.0f, ordinal=1)}, remap=false)
    private static float modifyLavaVisibilityVNoPotion(float original, ActiveRenderInfo camera) {
        List<LavaVisionPower> powers = OriginComponent.getPowers(camera.func_216773_g(), LavaVisionPower.class);
        if (powers.size() > 0) {
            return powers.get(0).getV();
        }
        return original;
    }

    @ModifyConstant(method={"setupFog"}, constant={@Constant(floatValue=0.0f, ordinal=0)}, remap=false)
    private static float modifyLavaVisibilitySWithPotion(float original, ActiveRenderInfo camera) {
        List<LavaVisionPower> powers = OriginComponent.getPowers(camera.func_216773_g(), LavaVisionPower.class);
        if (powers.size() > 0) {
            return powers.get(0).getS();
        }
        return original;
    }

    @ModifyConstant(method={"setupFog"}, constant={@Constant(floatValue=3.0f, ordinal=0)}, remap=false)
    private static float modifyLavaVisibilityVWithPotion(float original, ActiveRenderInfo camera) {
        List<LavaVisionPower> powers = OriginComponent.getPowers(camera.func_216773_g(), LavaVisionPower.class);
        if (powers.size() > 0) {
            return powers.get(0).getV();
        }
        return original;
    }
}

