/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin.forge;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.ClimbingPower;
import io.github.apace100.origins.power.ModifyHarvestPower;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ForgeHooks.class})
public class ForgeHooksMixin {
    @Inject(method={"canHarvestBlock"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private static void canHarvestBlockHook(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        CachedBlockInfo cbp = new CachedBlockInfo((IWorldReader)(world instanceof IWorldReader ? (IWorldReader)world : player.field_70170_p), pos, true);
        for (ModifyHarvestPower mhp : OriginComponent.getPowers((Entity)player, ModifyHarvestPower.class)) {
            if (!mhp.doesApply(cbp)) continue;
            cir.setReturnValue((Object)ForgeEventFactory.doPlayerHarvestCheck((PlayerEntity)player, (BlockState)state, (boolean)mhp.isHarvestAllowed()));
            cir.cancel();
        }
    }

    @Inject(method={"isLivingOnLadder"}, remap=false, at={@At(value="RETURN")}, cancellable=true)
    private static void ladder(BlockState state, World world, BlockPos pos, LivingEntity entity, CallbackInfoReturnable<Boolean> info) {
        List<ClimbingPower> climbingPowers;
        if (!((Boolean)info.getReturnValue()).booleanValue() && entity instanceof PlayerEntity && (climbingPowers = ModComponentsArchitectury.getOriginComponent((Entity)entity).getPowers(ClimbingPower.class, true)).size() > 0) {
            if (climbingPowers.stream().anyMatch(Power::isActive)) {
                info.setReturnValue((Object)true);
            } else if (entity.func_230491_ea_() && climbingPowers.stream().anyMatch(ClimbingPower::canHold)) {
                info.setReturnValue((Object)true);
            }
        }
    }
}

