/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.networking;

import architectury_inject_Origins_common_e21fe02eb57d45fe9fe41933609de5f3.PlatformMethods;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.ActionOnLandPower;
import io.github.apace100.origins.power.Active;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeRegistry;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Random;
import me.shedaniel.architectury.annotations.ExpectPlatform;
import me.shedaniel.architectury.networking.NetworkManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ModPacketsC2S {
    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)ModPackets.CHOOSE_ORIGIN, ModPacketsC2S::chooseOrigin);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)ModPackets.CHOOSE_RANDOM_ORIGIN, ModPacketsC2S::chooseRandomOrigin);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)ModPackets.USE_ACTIVE_POWERS, ModPacketsC2S::useActivePowers);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)ModPackets.PLAYER_LANDED, ModPacketsC2S::playerLanded);
        ModPacketsC2S.registerPlatformSpecificPackets();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerPlatformSpecificPackets() {
        PlatformMethods.platform("registerPlatformSpecificPackets");
    }

    private static void playerLanded(PacketBuffer packetByteBuf, NetworkManager.PacketContext context) {
        PlayerEntity playerEntity = context.getPlayer();
        context.queue(() -> OriginComponent.getPowers((Entity)playerEntity, ActionOnLandPower.class).forEach(ActionOnLandPower::executeAction));
    }

    private static void useActivePowers(PacketBuffer packetByteBuf, NetworkManager.PacketContext context) {
        PlayerEntity playerEntity = context.getPlayer();
        int count = packetByteBuf.readInt();
        ResourceLocation[] powerIds = new ResourceLocation[count];
        for (int i = 0; i < count; ++i) {
            powerIds[i] = packetByteBuf.func_192575_l();
        }
        context.queue(() -> {
            OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)playerEntity);
            for (ResourceLocation id : powerIds) {
                PowerType type = PowerTypeRegistry.get(id);
                Object power = component.getPower(type);
                if (!(power instanceof Active)) continue;
                ((Active)power).onUse();
            }
        });
    }

    private static void chooseOrigin(PacketBuffer packetByteBuf, NetworkManager.PacketContext context) {
        PlayerEntity playerEntity = context.getPlayer();
        String originId = packetByteBuf.func_150789_c(Short.MAX_VALUE);
        String layerId = packetByteBuf.func_150789_c(Short.MAX_VALUE);
        context.queue(() -> {
            OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)playerEntity);
            OriginLayer layer = OriginLayers.getLayer(ResourceLocation.func_208304_a((String)layerId));
            if (!component.hasAllOrigins() && !component.hasOrigin(layer)) {
                ResourceLocation id = ResourceLocation.func_208304_a((String)originId);
                if (id != null) {
                    Origin origin = OriginRegistry.get(id);
                    if (origin.isChoosable() && layer.contains(origin, playerEntity)) {
                        boolean hadOriginBefore = component.hadOriginBefore();
                        boolean hadAllOrigins = component.hasAllOrigins();
                        component.setOrigin(layer, origin);
                        component.checkAutoChoosingLayers(playerEntity, false);
                        component.sync();
                        if (component.hasAllOrigins() && !hadAllOrigins) {
                            component.getOrigins().values().forEach(o -> o.getPowerTypes().forEach(powerType -> ((Power)component.getPower(powerType)).onChosen(hadOriginBefore)));
                        }
                        Origins.LOGGER.info("Player " + playerEntity.func_145748_c_().func_150261_e() + " chose Origin: " + originId + ", for layer: " + layerId);
                    } else {
                        Origins.LOGGER.info("Player " + playerEntity.func_145748_c_().func_150261_e() + " tried to choose unchoosable Origin for layer " + layerId + ": " + originId + ".");
                        component.setOrigin(layer, Origin.EMPTY);
                    }
                    ModPacketsC2S.confirmOrigin((ServerPlayerEntity)playerEntity, layer, component.getOrigin(layer));
                    component.sync();
                } else {
                    Origins.LOGGER.warn("Player " + playerEntity.func_145748_c_().func_150261_e() + " chose unknown origin: " + originId);
                }
            } else {
                Origins.LOGGER.warn("Player " + playerEntity.func_145748_c_().func_150261_e() + " tried to choose origin for layer " + layerId + " while having one already.");
            }
        });
    }

    private static void chooseRandomOrigin(PacketBuffer packetByteBuf, NetworkManager.PacketContext context) {
        PlayerEntity playerEntity = context.getPlayer();
        String layerId = packetByteBuf.func_150789_c(Short.MAX_VALUE);
        context.queue(() -> {
            OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)playerEntity);
            OriginLayer layer = OriginLayers.getLayer(ResourceLocation.func_208304_a((String)layerId));
            if (!component.hasAllOrigins() && !component.hasOrigin(layer)) {
                List<ResourceLocation> randomOrigins = layer.getRandomOrigins(playerEntity);
                if (layer.isRandomAllowed() && randomOrigins.size() > 0) {
                    ResourceLocation randomOrigin = randomOrigins.get(new Random().nextInt(randomOrigins.size()));
                    Origin origin = OriginRegistry.get(randomOrigin);
                    boolean hadOriginBefore = component.hadOriginBefore();
                    boolean hadAllOrigins = component.hasAllOrigins();
                    component.setOrigin(layer, origin);
                    component.checkAutoChoosingLayers(playerEntity, false);
                    component.sync();
                    if (component.hasAllOrigins() && !hadAllOrigins) {
                        component.getOrigins().values().forEach(o -> o.getPowerTypes().forEach(powerType -> ((Power)component.getPower(powerType)).onChosen(hadOriginBefore)));
                    }
                    Origins.LOGGER.info("Player " + playerEntity.func_145748_c_().func_150261_e() + " was randomly assigned the following Origin: " + randomOrigin + ", for layer: " + layerId);
                } else {
                    Origins.LOGGER.info("Player " + playerEntity.func_145748_c_().func_150261_e() + " tried to choose a random Origin for layer " + layerId + ", which is not allowed!");
                    component.setOrigin(layer, Origin.EMPTY);
                }
                ModPacketsC2S.confirmOrigin((ServerPlayerEntity)playerEntity, layer, component.getOrigin(layer));
                component.sync();
            } else {
                Origins.LOGGER.warn("Player " + playerEntity.func_145748_c_().func_150261_e() + " tried to choose origin for layer " + layerId + " while having one already.");
            }
        });
    }

    private static void confirmOrigin(ServerPlayerEntity player, OriginLayer layer, Origin origin) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.func_192572_a(layer.getIdentifier());
        buf.func_192572_a(origin.getIdentifier());
        NetworkManager.sendToPlayer((ServerPlayerEntity)player, (ResourceLocation)ModPackets.CONFIRM_ORIGIN, (PacketBuffer)buf);
    }
}

