/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.networking;

import architectury_inject_Origins_common_e21fe02eb57d45fe9fe41933609de5f3.PlatformMethods;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.integration.OriginDataLoadedCallback;
import io.github.apace100.origins.integration.OriginEventsArchitectury;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeRegistry;
import io.github.apace100.origins.power.factory.PowerFactory;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.github.apace100.origins.registry.ModRegistriesArchitectury;
import io.github.apace100.origins.screen.ChooseOriginScreen;
import io.github.apace100.origins.screen.WaitForNextLayerScreen;
import io.github.apace100.origins.util.SerializableData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import me.shedaniel.architectury.annotations.ExpectPlatform;
import me.shedaniel.architectury.networking.NetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModPacketsS2C {
    @OnlyIn(value=Dist.CLIENT)
    public static void register() {
        ModPacketsS2C.registerPlatformSpecificPackets();
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)ModPackets.OPEN_ORIGIN_SCREEN, ModPacketsS2C::openOriginScreen);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)ModPackets.ORIGIN_LIST, ModPacketsS2C::receiveOriginList);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)ModPackets.LAYER_LIST, ModPacketsS2C::receiveLayerList);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)ModPackets.POWER_LIST, ModPacketsS2C::receivePowerList);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)ModPackets.CONFIRM_ORIGIN, ModPacketsS2C::receiveOriginConfirmation);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerPlatformSpecificPackets() {
        PlatformMethods.platform("registerPlatformSpecificPackets");
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void receiveOriginConfirmation(PacketBuffer packetByteBuf, NetworkManager.PacketContext context) {
        OriginLayer layer = OriginLayers.getLayer(packetByteBuf.func_192575_l());
        Origin origin = OriginRegistry.get(packetByteBuf.func_192575_l());
        context.queue(() -> {
            Minecraft minecraftClient = Minecraft.func_71410_x();
            OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)minecraftClient.field_71439_g);
            component.setOrigin(layer, origin);
            if (minecraftClient.field_71462_r instanceof WaitForNextLayerScreen) {
                ((WaitForNextLayerScreen)minecraftClient.field_71462_r).openSelection();
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openOriginScreen(PacketBuffer packetByteBuf, NetworkManager.PacketContext context) {
        boolean showDirtBackground = packetByteBuf.readBoolean();
        context.queue(() -> {
            Minecraft minecraftClient = Minecraft.func_71410_x();
            if (minecraftClient.field_71462_r instanceof ChooseOriginScreen) {
                return;
            }
            ArrayList<OriginLayer> layers = new ArrayList<OriginLayer>();
            OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)minecraftClient.field_71439_g);
            OriginLayers.getLayers().forEach(layer -> {
                if (layer.isEnabled() && !component.hasOrigin((OriginLayer)layer)) {
                    layers.add((OriginLayer)layer);
                }
            });
            Collections.sort(layers);
            minecraftClient.func_147108_a((Screen)new ChooseOriginScreen(layers, 0, showDirtBackground));
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void receiveOriginList(PacketBuffer packetByteBuf, NetworkManager.PacketContext context) {
        ResourceLocation[] ids = new ResourceLocation[packetByteBuf.readInt()];
        SerializableData.Instance[] origins = new SerializableData.Instance[ids.length];
        for (int i = 0; i < origins.length; ++i) {
            ids[i] = ResourceLocation.func_208304_a((String)packetByteBuf.func_218666_n());
            origins[i] = Origin.DATA.read(packetByteBuf);
        }
        context.queue(() -> {
            OriginRegistry.reset();
            for (int i = 0; i < ids.length; ++i) {
                OriginRegistry.register(ids[i], Origin.createFromData(ids[i], origins[i]));
            }
            ((OriginDataLoadedCallback)OriginEventsArchitectury.ORIGINS_LOADED.invoker()).onDataLoaded(true);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void receiveLayerList(PacketBuffer packetByteBuf, NetworkManager.PacketContext context) {
        int layerCount = packetByteBuf.readInt();
        OriginLayer[] layers = new OriginLayer[layerCount];
        for (int i = 0; i < layerCount; ++i) {
            layers[i] = OriginLayer.read(packetByteBuf);
        }
        context.queue(() -> {
            OriginLayers.clear();
            for (int i = 0; i < layerCount; ++i) {
                OriginLayers.add(layers[i]);
            }
            ((OriginDataLoadedCallback)OriginEventsArchitectury.ORIGIN_LAYERS_LOADED.invoker()).onDataLoaded(true);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void receivePowerList(PacketBuffer packetByteBuf, NetworkManager.PacketContext context) {
        int powerCount = packetByteBuf.readInt();
        HashMap factories = new HashMap();
        for (int i = 0; i < powerCount; ++i) {
            ResourceLocation powerId = packetByteBuf.func_192575_l();
            ResourceLocation factoryId = packetByteBuf.func_192575_l();
            PowerFactory factory = (PowerFactory)((Object)ModRegistriesArchitectury.POWER_FACTORY.get(factoryId));
            PowerFactory.Instance factoryInstance = factory.read(packetByteBuf);
            PowerType type = new PowerType(powerId, factoryInstance);
            type.setTranslationKeys(packetByteBuf.func_218666_n(), packetByteBuf.func_218666_n());
            if (packetByteBuf.readBoolean()) {
                type.setHidden();
            }
            factories.put(powerId, type);
        }
        context.queue(() -> {
            PowerTypeRegistry.clear();
            factories.forEach(PowerTypeRegistry::register);
        });
        ((OriginDataLoadedCallback)OriginEventsArchitectury.POWER_TYPES_LOADED.invoker()).onDataLoaded(true);
    }
}

