/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public enum Impact {
    NONE(0, "none", TextFormatting.GRAY),
    LOW(1, "low", TextFormatting.GREEN),
    MEDIUM(2, "medium", TextFormatting.YELLOW),
    HIGH(3, "high", TextFormatting.RED);

    private int impactValue;
    private String translationKey;
    private TextFormatting textStyle;

    private Impact(int impactValue, String translationKey, TextFormatting textStyle) {
        this.translationKey = "origins.gui.impact." + translationKey;
        this.impactValue = impactValue;
        this.textStyle = textStyle;
    }

    public int getImpactValue() {
        return this.impactValue;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public TextFormatting getTextStyle() {
        return this.textStyle;
    }

    public TranslationTextComponent getTextComponent() {
        return (TranslationTextComponent)new TranslationTextComponent(this.getTranslationKey()).func_240699_a_(this.getTextStyle());
    }

    public static Impact getByValue(int impactValue) {
        return Impact.values()[impactValue];
    }
}

