/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.power.factory.condition.ConditionTypes;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OriginLayer
implements Comparable<OriginLayer> {
    private int order;
    private ResourceLocation identifier;
    private List<ConditionedOrigin> conditionedOrigins;
    private boolean enabled = false;
    private String nameTranslationKey;
    private String missingOriginNameTranslationKey;
    private String missingOriginDescriptionTranslationKey;
    private boolean isRandomAllowed = false;
    private boolean doesRandomAllowUnchoosable = false;
    private List<ResourceLocation> originsExcludedFromRandom = null;
    private ResourceLocation defaultOrigin = null;
    private boolean autoChooseIfNoChoice = false;

    public String getOrCreateTranslationKey() {
        if (this.nameTranslationKey == null || this.nameTranslationKey.isEmpty()) {
            this.nameTranslationKey = "layer." + this.identifier.func_110624_b() + "." + this.identifier.func_110623_a() + ".name";
        }
        return this.nameTranslationKey;
    }

    public String getTranslationKey() {
        return this.getOrCreateTranslationKey();
    }

    public String getMissingOriginNameTranslationKey() {
        if (this.missingOriginNameTranslationKey == null || this.missingOriginNameTranslationKey.isEmpty()) {
            this.missingOriginNameTranslationKey = "layer." + this.identifier.func_110624_b() + "." + this.identifier.func_110623_a() + ".missing_origin.name";
        }
        return this.missingOriginNameTranslationKey;
    }

    public String getMissingOriginDescriptionTranslationKey() {
        if (this.missingOriginDescriptionTranslationKey == null || this.missingOriginDescriptionTranslationKey.isEmpty()) {
            this.missingOriginDescriptionTranslationKey = "layer." + this.identifier.func_110624_b() + "." + this.identifier.func_110623_a() + ".missing_origin.description";
        }
        return this.missingOriginDescriptionTranslationKey;
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasDefaultOrigin() {
        return this.defaultOrigin != null;
    }

    public ResourceLocation getDefaultOrigin() {
        return this.defaultOrigin;
    }

    public boolean shouldAutoChoose() {
        return this.autoChooseIfNoChoice;
    }

    public List<ResourceLocation> getOrigins() {
        return this.conditionedOrigins.stream().flatMap(co -> co.getOrigins().stream()).filter(OriginRegistry::contains).distinct().collect(Collectors.toList());
    }

    public List<ResourceLocation> getOrigins(PlayerEntity playerEntity) {
        return this.conditionedOrigins.stream().filter(co -> co.isConditionFulfilled(playerEntity)).flatMap(co -> co.getOrigins().stream()).filter(OriginRegistry::contains).distinct().collect(Collectors.toList());
    }

    public int getOriginOptionCount(PlayerEntity playerEntity) {
        long choosableOrigins = this.getOrigins(playerEntity).stream().map(OriginRegistry::get).filter(Origin::isChoosable).count();
        if (this.isRandomAllowed && this.getRandomOrigins(playerEntity).size() > 0) {
            ++choosableOrigins;
        }
        return (int)choosableOrigins;
    }

    public boolean contains(Origin origin) {
        return this.conditionedOrigins.stream().anyMatch(co -> co.getOrigins().stream().anyMatch(o -> o.equals((Object)origin.getIdentifier())));
    }

    public boolean contains(Origin origin, PlayerEntity playerEntity) {
        return this.conditionedOrigins.stream().filter(co -> co.isConditionFulfilled(playerEntity)).anyMatch(co -> co.getOrigins().stream().anyMatch(o -> o.equals((Object)origin.getIdentifier())));
    }

    public boolean isRandomAllowed() {
        return this.isRandomAllowed;
    }

    public List<ResourceLocation> getRandomOrigins(PlayerEntity playerEntity) {
        return this.conditionedOrigins.stream().filter(co -> co.isConditionFulfilled(playerEntity)).flatMap(co -> co.getOrigins().stream()).filter(OriginRegistry::contains).filter(o -> !this.originsExcludedFromRandom.contains(o)).filter(id -> this.doesRandomAllowUnchoosable || OriginRegistry.get(id).isChoosable()).distinct().collect(Collectors.toList());
    }

    public void merge(JsonObject json) {
        if (json.has("order")) {
            this.order = json.get("order").getAsInt();
        }
        if (json.has("enabled")) {
            this.enabled = json.get("enabled").getAsBoolean();
        }
        if (json.has("origins")) {
            JsonArray originArray = json.getAsJsonArray("origins");
            originArray.forEach(je -> this.conditionedOrigins.add(ConditionedOrigin.read(je)));
        }
        if (json.has("name")) {
            this.nameTranslationKey = JSONUtils.func_151219_a((JsonObject)json, (String)"name", (String)"");
        }
        if (json.has("missing_name")) {
            this.missingOriginNameTranslationKey = JSONUtils.func_151219_a((JsonObject)json, (String)"missing_name", (String)"");
        }
        if (json.has("missing_description")) {
            this.missingOriginDescriptionTranslationKey = JSONUtils.func_151219_a((JsonObject)json, (String)"missing_description", (String)"");
        }
        if (json.has("allow_random")) {
            this.isRandomAllowed = JSONUtils.func_151212_i((JsonObject)json, (String)"allow_random");
        }
        if (json.has("allow_random_unchoosable")) {
            this.doesRandomAllowUnchoosable = JSONUtils.func_151212_i((JsonObject)json, (String)"allow_random_unchoosable");
        }
        if (json.has("exclude_random") && json.get("exclude_random").isJsonArray()) {
            boolean replaceExclude = JSONUtils.func_151209_a((JsonObject)json, (String)"replace_exclude_random", (boolean)false);
            if (replaceExclude) {
                this.originsExcludedFromRandom.clear();
            }
            JsonArray excludeRandomArray = json.getAsJsonArray("exclude_random");
            excludeRandomArray.forEach(je -> this.originsExcludedFromRandom.add(ResourceLocation.func_208304_a((String)je.getAsString())));
        }
        if (json.has("default_origin")) {
            this.defaultOrigin = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"default_origin"));
        }
        if (json.has("auto_choose")) {
            this.autoChooseIfNoChoice = JSONUtils.func_151212_i((JsonObject)json, (String)"auto_choose");
        }
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OriginLayer)) {
            return false;
        }
        return this.identifier.equals((Object)((OriginLayer)obj).identifier);
    }

    @Override
    public int compareTo(OriginLayer o) {
        return Integer.compare(this.order, o.order);
    }

    public void write(PacketBuffer buffer) {
        buffer.func_180714_a(this.identifier.toString());
        buffer.writeInt(this.order);
        buffer.writeBoolean(this.enabled);
        buffer.writeInt(this.conditionedOrigins.size());
        this.conditionedOrigins.forEach(co -> co.write(buffer));
        buffer.func_180714_a(this.getOrCreateTranslationKey());
        buffer.func_180714_a(this.getMissingOriginNameTranslationKey());
        buffer.func_180714_a(this.getMissingOriginDescriptionTranslationKey());
        buffer.writeBoolean(this.isRandomAllowed());
        if (this.isRandomAllowed()) {
            buffer.writeBoolean(this.doesRandomAllowUnchoosable);
            buffer.writeInt(this.originsExcludedFromRandom.size());
            this.originsExcludedFromRandom.forEach(arg_0 -> ((PacketBuffer)buffer).func_192572_a(arg_0));
        }
        buffer.writeBoolean(this.hasDefaultOrigin());
        if (this.hasDefaultOrigin()) {
            buffer.func_192572_a(this.defaultOrigin);
        }
        buffer.writeBoolean(this.autoChooseIfNoChoice);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static OriginLayer read(PacketBuffer buffer) {
        OriginLayer layer = new OriginLayer();
        layer.identifier = ResourceLocation.func_208304_a((String)buffer.func_218666_n());
        layer.order = buffer.readInt();
        layer.enabled = buffer.readBoolean();
        int conditionedOriginCount = buffer.readInt();
        layer.conditionedOrigins = new ArrayList<ConditionedOrigin>(conditionedOriginCount);
        for (int i = 0; i < conditionedOriginCount; ++i) {
            layer.conditionedOrigins.add(ConditionedOrigin.read(buffer));
        }
        layer.nameTranslationKey = buffer.func_218666_n();
        layer.missingOriginNameTranslationKey = buffer.func_218666_n();
        layer.missingOriginDescriptionTranslationKey = buffer.func_218666_n();
        layer.isRandomAllowed = buffer.readBoolean();
        if (layer.isRandomAllowed) {
            layer.doesRandomAllowUnchoosable = buffer.readBoolean();
            int excludedSize = buffer.readInt();
            layer.originsExcludedFromRandom = new LinkedList<ResourceLocation>();
            for (int i = 0; i < excludedSize; ++i) {
                layer.originsExcludedFromRandom.add(buffer.func_192575_l());
            }
        }
        if (buffer.readBoolean()) {
            layer.defaultOrigin = buffer.func_192575_l();
        }
        layer.autoChooseIfNoChoice = buffer.readBoolean();
        return layer;
    }

    public static OriginLayer fromJson(ResourceLocation id, JsonObject json) {
        int order = JSONUtils.func_151208_a((JsonObject)json, (String)"order", (int)OriginLayers.size());
        if (!json.has("origins") || !json.get("origins").isJsonArray()) {
            throw new JsonParseException("Origin layer JSON requires \"origins\" array of origin IDs to include in the layer.");
        }
        JsonArray originArray = json.getAsJsonArray("origins");
        ArrayList<ConditionedOrigin> list = new ArrayList<ConditionedOrigin>(originArray.size());
        originArray.forEach(je -> list.add(ConditionedOrigin.read(je)));
        boolean enabled = JSONUtils.func_151209_a((JsonObject)json, (String)"enabled", (boolean)true);
        OriginLayer layer = new OriginLayer();
        layer.order = order;
        layer.conditionedOrigins = list;
        layer.enabled = enabled;
        layer.identifier = id;
        layer.nameTranslationKey = JSONUtils.func_151219_a((JsonObject)json, (String)"name", (String)"");
        layer.missingOriginNameTranslationKey = JSONUtils.func_151219_a((JsonObject)json, (String)"missing_name", (String)"");
        layer.missingOriginDescriptionTranslationKey = JSONUtils.func_151219_a((JsonObject)json, (String)"missing_description", (String)"");
        layer.isRandomAllowed = JSONUtils.func_151209_a((JsonObject)json, (String)"allow_random", (boolean)false);
        layer.doesRandomAllowUnchoosable = JSONUtils.func_151209_a((JsonObject)json, (String)"allow_random_unchoosable", (boolean)false);
        layer.originsExcludedFromRandom = new LinkedList<ResourceLocation>();
        if (json.has("exclude_random") && json.get("exclude_random").isJsonArray()) {
            JsonArray excludeRandomArray = json.getAsJsonArray("exclude_random");
            excludeRandomArray.forEach(je -> layer.originsExcludedFromRandom.add(ResourceLocation.func_208304_a((String)je.getAsString())));
        }
        if (json.has("default_origin")) {
            layer.defaultOrigin = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"default_origin"));
        }
        layer.autoChooseIfNoChoice = JSONUtils.func_151209_a((JsonObject)json, (String)"auto_choose", (boolean)false);
        return layer;
    }

    public static class ConditionedOrigin {
        private final ConditionFactory.Instance condition;
        private final List<ResourceLocation> origins;
        private static final SerializableData conditionedOriginObjectData = new SerializableData().add("condition", SerializableDataType.ENTITY_CONDITION).add("origins", SerializableDataType.IDENTIFIERS);

        public ConditionedOrigin(ConditionFactory.Instance condition, List<ResourceLocation> origins) {
            this.condition = condition;
            this.origins = origins;
        }

        public boolean isConditionFulfilled(PlayerEntity playerEntity) {
            return this.condition == null || this.condition.test(playerEntity);
        }

        public List<ResourceLocation> getOrigins() {
            return this.origins;
        }

        public void write(PacketBuffer buffer) {
            buffer.writeBoolean(this.condition != null);
            if (this.condition != null) {
                this.condition.write(buffer);
            }
            buffer.writeInt(this.origins.size());
            this.origins.forEach(arg_0 -> ((PacketBuffer)buffer).func_192572_a(arg_0));
        }

        @OnlyIn(value=Dist.CLIENT)
        public static ConditionedOrigin read(PacketBuffer buffer) {
            ConditionFactory.Instance condition = null;
            if (buffer.readBoolean()) {
                condition = ConditionTypes.ENTITY.read(buffer);
            }
            int originCount = buffer.readInt();
            ArrayList<ResourceLocation> originList = new ArrayList<ResourceLocation>(originCount);
            for (int i = 0; i < originCount; ++i) {
                originList.add(buffer.func_192575_l());
            }
            return new ConditionedOrigin(condition, originList);
        }

        public static ConditionedOrigin read(JsonElement element) {
            if (element.isJsonPrimitive()) {
                JsonPrimitive elemPrimitive = element.getAsJsonPrimitive();
                if (elemPrimitive.isString()) {
                    return new ConditionedOrigin(null, Lists.newArrayList((Object[])new ResourceLocation[]{ResourceLocation.func_208304_a((String)elemPrimitive.getAsString())}));
                }
                throw new JsonParseException("Expected origin in layer to be either a string or an object.");
            }
            if (element.isJsonObject()) {
                SerializableData.Instance data = conditionedOriginObjectData.read(element.getAsJsonObject());
                return new ConditionedOrigin((ConditionFactory.Instance)data.get("condition"), (List)data.get("origins"));
            }
            throw new JsonParseException("Expected origin in layer to be either a string or an object.");
        }
    }
}

