/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.integration.OriginDataLoadedCallback;
import io.github.apace100.origins.integration.OriginEventsArchitectury;
import io.github.apace100.origins.integration.OriginLoadingEvent;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.util.MultiJsonDataLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class OriginLayers
extends MultiJsonDataLoader {
    private static HashMap<ResourceLocation, OriginLayer> layers = new HashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public OriginLayers() {
        super(GSON, "origin_layers");
    }

    private static void fireLoadingEvent(OriginLayer layer) {
        ((OriginLoadingEvent)OriginEventsArchitectury.ORIGIN_LAYER_LOADING.invoker()).onLoad(layer);
    }

    protected void apply(Map<ResourceLocation, List<JsonElement>> loader, IResourceManager manager, IProfiler profiler) {
        OriginLayers.clear();
        loader.forEach((id, jel) -> jel.forEach(je -> {
            try {
                Origins.LOGGER.info("Trying to read layer file: " + id);
                JsonObject jo = je.getAsJsonObject();
                boolean replace = JSONUtils.func_151209_a((JsonObject)jo, (String)"replace", (boolean)false);
                if (layers.containsKey(id)) {
                    if (replace) {
                        OriginLayer layer = OriginLayer.fromJson(id, jo);
                        OriginLayers.fireLoadingEvent(layer);
                        layers.put((ResourceLocation)id, layer);
                    } else {
                        Origins.LOGGER.info("Merging origin layer " + id.toString());
                        layers.get(id).merge(jo);
                        OriginLayers.fireLoadingEvent(layers.get(id));
                    }
                } else {
                    OriginLayer layer = OriginLayer.fromJson(id, jo);
                    OriginLayers.fireLoadingEvent(layer);
                    layers.put((ResourceLocation)id, layer);
                }
            }
            catch (Exception e) {
                Origins.LOGGER.error("There was a problem reading Origin layer file " + id.toString() + " (skipping): " + e.getMessage());
            }
        }));
        Origins.LOGGER.info("Finished loading origin layers from data files. Read " + layers.size() + " layers.");
        ((OriginDataLoadedCallback)OriginEventsArchitectury.ORIGIN_LAYERS_LOADED.invoker()).onDataLoaded(false);
    }

    public static OriginLayer getLayer(ResourceLocation id) {
        return layers.get(id);
    }

    public static Collection<OriginLayer> getLayers() {
        return layers.values();
    }

    public static int size() {
        return layers.size();
    }

    public static void clear() {
        layers.clear();
    }

    public static void add(OriginLayer layer) {
        layers.put(layer.getIdentifier(), layer);
    }

    public ResourceLocation getFabricId() {
        return new ResourceLocation("origins", "origin_layers");
    }
}

