/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.integration.OriginDataLoadedCallback;
import io.github.apace100.origins.integration.OriginEventsArchitectury;
import io.github.apace100.origins.integration.OriginLoadingEvent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.util.MultiJsonDataLoader;
import java.util.List;
import java.util.Map;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class OriginManager
extends MultiJsonDataLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public OriginManager() {
        super(GSON, "origins");
    }

    private static void fireLoadingEvent(Origin origin) {
        ((OriginLoadingEvent)OriginEventsArchitectury.ORIGIN_LOADING.invoker()).onLoad(origin);
    }

    protected void apply(Map<ResourceLocation, List<JsonElement>> loader, IResourceManager manager, IProfiler profiler) {
        OriginRegistry.reset();
        loader.forEach((id, jel) -> jel.forEach(je -> {
            try {
                Origin origin = Origin.fromJson(id, je.getAsJsonObject());
                OriginManager.fireLoadingEvent(origin);
                if (!OriginRegistry.contains(id)) {
                    OriginRegistry.register(id, origin);
                } else if (OriginRegistry.get(id).getLoadingPriority() < origin.getLoadingPriority()) {
                    OriginRegistry.update(id, origin);
                }
            }
            catch (Exception e) {
                Origins.LOGGER.error("There was a problem reading Origin file " + id.toString() + " (skipping): " + e.getMessage());
            }
        }));
        Origins.LOGGER.info("Finished loading origins from data files. Registry contains " + OriginRegistry.size() + " origins.");
        ((OriginDataLoadedCallback)OriginEventsArchitectury.ORIGINS_LOADED.invoker()).onDataLoaded(false);
    }

    public ResourceLocation getFabricId() {
        return new ResourceLocation("origins", "origins");
    }
}

