/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class OriginUpgrade {
    private final ResourceLocation advancementCondition;
    private final ResourceLocation upgradeToOrigin;
    private final String announcement;

    public OriginUpgrade(ResourceLocation advancementCondition, ResourceLocation upgradeToOrigin, String announcement) {
        this.advancementCondition = advancementCondition;
        this.upgradeToOrigin = upgradeToOrigin;
        this.announcement = announcement;
    }

    public ResourceLocation getAdvancementCondition() {
        return this.advancementCondition;
    }

    public ResourceLocation getUpgradeToOrigin() {
        return this.upgradeToOrigin;
    }

    public String getAnnouncement() {
        return this.announcement;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.advancementCondition);
        buffer.func_192572_a(this.upgradeToOrigin);
        buffer.func_180714_a(this.announcement);
    }

    public static OriginUpgrade read(PacketBuffer buffer) {
        ResourceLocation condition = buffer.func_192575_l();
        ResourceLocation origin = buffer.func_192575_l();
        String announcement = buffer.func_150789_c(Short.MAX_VALUE);
        return new OriginUpgrade(condition, origin, announcement);
    }

    public static OriginUpgrade fromJson(JsonElement jsonElement) {
        JsonElement origin;
        JsonElement condition;
        if (!jsonElement.isJsonObject()) {
            throw new JsonParseException("Origin upgrade needs to be a JSON object.");
        }
        JsonObject json = jsonElement.getAsJsonObject();
        if (json.has("condition") && (condition = json.get("condition")).isJsonPrimitive() && json.has("origin") && (origin = json.get("origin")).isJsonPrimitive()) {
            JsonElement anno;
            ResourceLocation conditionId = ResourceLocation.func_208304_a((String)condition.getAsString());
            ResourceLocation originId = ResourceLocation.func_208304_a((String)origin.getAsString());
            String announcement = "";
            if (json.has("announcement") && (anno = json.get("announcement")).isJsonPrimitive()) {
                announcement = anno.getAsString();
            }
            return new OriginUpgrade(conditionId, originId, announcement);
        }
        throw new JsonParseException("Origin upgrade JSON requires \"condition\" string and \"origin\" string.");
    }
}

