/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public class ActionOnItemUsePower
extends Power {
    private final Predicate<ItemStack> itemCondition;
    private final Consumer<Entity> entityAction;
    private final Consumer<ItemStack> itemAction;

    public ActionOnItemUsePower(PowerType<?> type, PlayerEntity player, Predicate<ItemStack> itemCondition, Consumer<Entity> entityAction, Consumer<ItemStack> itemAction) {
        super(type, player);
        this.itemCondition = itemCondition;
        this.entityAction = entityAction;
        this.itemAction = itemAction;
    }

    public boolean doesApply(ItemStack stack) {
        return this.itemCondition == null || this.itemCondition.test(stack);
    }

    public void executeActions(ItemStack stack) {
        if (this.itemAction != null) {
            this.itemAction.accept(stack);
        }
        if (this.entityAction != null) {
            this.entityAction.accept((Entity)this.player);
        }
    }
}

