/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;

public class ActionOverTimePower
extends Power {
    private final int interval;
    private final Consumer<Entity> entityAction;
    private final Consumer<Entity> risingAction;
    private final Consumer<Entity> fallingAction;
    private boolean wasActive = false;

    public ActionOverTimePower(PowerType<?> type, PlayerEntity player, int interval, Consumer<Entity> entityAction, Consumer<Entity> risingAction, Consumer<Entity> fallingAction) {
        super(type, player);
        this.interval = interval;
        this.entityAction = entityAction;
        this.risingAction = risingAction;
        this.fallingAction = fallingAction;
        this.setTicking(true);
    }

    @Override
    public void tick() {
        if (this.player.field_70173_aa % this.interval == 0) {
            if (this.isActive()) {
                if (this.entityAction != null) {
                    this.entityAction.accept((Entity)this.player);
                }
                if (!this.wasActive && this.risingAction != null) {
                    this.risingAction.accept((Entity)this.player);
                }
                this.wasActive = true;
            } else {
                if (this.wasActive && this.fallingAction != null) {
                    this.fallingAction.accept((Entity)this.player);
                }
                this.wasActive = false;
            }
        }
    }

    @Override
    public INBT toTag() {
        return ByteNBT.func_229672_a_((boolean)this.wasActive);
    }

    @Override
    public void fromTag(INBT tag) {
        this.wasActive = tag.equals(ByteNBT.field_229670_c_);
    }
}

