/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;

public class ConditionedRestrictArmorPower
extends Power {
    private final HashMap<EquipmentSlotType, Predicate<ItemStack>> armorConditions;
    private final int tickRate;

    public ConditionedRestrictArmorPower(PowerType<?> type, PlayerEntity player, HashMap<EquipmentSlotType, Predicate<ItemStack>> armorConditions, int tickRate) {
        super(type, player);
        this.armorConditions = armorConditions;
        this.setTicking(true);
        this.tickRate = tickRate;
    }

    public boolean canEquip(ItemStack itemStack, EquipmentSlotType slot) {
        return !this.armorConditions.get(slot).test(itemStack);
    }

    @Override
    public void tick() {
        if (this.player.field_70173_aa % this.tickRate == 0 && this.isActive()) {
            for (EquipmentSlotType slot : this.armorConditions.keySet()) {
                ItemStack equippedItem = this.player.func_184582_a(slot);
                if (equippedItem.func_190926_b() || this.canEquip(equippedItem, slot)) continue;
                if (!this.player.field_71071_by.func_70441_a(equippedItem)) {
                    this.player.func_71019_a(equippedItem, true);
                }
                this.player.func_184201_a(slot, ItemStack.field_190927_a);
            }
        }
    }
}

