/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Active;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.DispenserContainer;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class InventoryPower
extends Power
implements Active,
IInventory {
    private final int size;
    private final NonNullList<ItemStack> inventory;
    private final TranslationTextComponent containerName;
    private final IContainerProvider factory;
    private final boolean shouldDropOnDeath;
    private final Predicate<ItemStack> dropOnDeathFilter;
    private Active.Key key;

    public InventoryPower(PowerType<?> type, PlayerEntity player, String containerName, int size, boolean shouldDropOnDeath, Predicate<ItemStack> dropOnDeathFilter) {
        super(type, player);
        this.size = size;
        this.inventory = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.containerName = new TranslationTextComponent(containerName);
        this.factory = (i, playerInventory, playerEntity) -> new DispenserContainer(i, playerInventory, (IInventory)this);
        this.shouldDropOnDeath = shouldDropOnDeath;
        this.dropOnDeathFilter = dropOnDeathFilter;
    }

    @Override
    public void onUse() {
        if (!this.player.field_70170_p.field_72995_K) {
            this.player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider(this.factory, (ITextComponent)this.containerName));
        }
    }

    @Override
    public INBT toTag() {
        CompoundNBT tag = new CompoundNBT();
        ItemStackHelper.func_191282_a((CompoundNBT)tag, this.inventory);
        return tag;
    }

    @Override
    public void fromTag(INBT tag) {
        ItemStackHelper.func_191283_b((CompoundNBT)((CompoundNBT)tag), this.inventory);
    }

    public int func_70302_i_() {
        return this.size;
    }

    public boolean func_191420_l() {
        return this.inventory.isEmpty();
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return ((ItemStack)this.inventory.get(slot)).func_77979_a(amount);
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        this.func_70299_a(slot, ItemStack.field_190927_a);
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(PlayerEntity player) {
        return player == this.player;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.size; ++i) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public boolean shouldDropOnDeath() {
        return this.shouldDropOnDeath;
    }

    public boolean shouldDropOnDeath(ItemStack stack) {
        return this.shouldDropOnDeath && this.dropOnDeathFilter.test(stack);
    }

    @Override
    public Active.Key getKey() {
        return this.key;
    }

    @Override
    public void setKey(Active.Key key) {
        this.key = key;
    }
}

