/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.ValueModifyingPower;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Tuple;

public class ModifyDamageDealtPower
extends ValueModifyingPower {
    private final Predicate<Tuple<DamageSource, Float>> condition;
    private final Predicate<LivingEntity> targetCondition;
    private Consumer<LivingEntity> targetAction;
    private Consumer<LivingEntity> selfAction;

    public ModifyDamageDealtPower(PowerType<?> type, PlayerEntity player, Predicate<Tuple<DamageSource, Float>> condition, Predicate<LivingEntity> targetCondition) {
        super(type, player);
        this.condition = condition;
        this.targetCondition = targetCondition;
    }

    public boolean doesApply(DamageSource source, float damageAmount, LivingEntity target) {
        return this.condition.test((Tuple<DamageSource, Float>)new Tuple((Object)source, (Object)Float.valueOf(damageAmount))) && (target == null || this.targetCondition == null || this.targetCondition.test(target));
    }

    public void setTargetAction(Consumer<LivingEntity> targetAction) {
        this.targetAction = targetAction;
    }

    public void setSelfAction(Consumer<LivingEntity> selfAction) {
        this.selfAction = selfAction;
    }

    public void executeActions(Entity target) {
        if (this.selfAction != null) {
            this.selfAction.accept((LivingEntity)this.player);
        }
        if (this.targetAction != null && target instanceof LivingEntity) {
            this.targetAction.accept((LivingEntity)target);
        }
    }
}

