/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.Optional;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.Tuple;
import net.minecraft.util.Unit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IStructureReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;

public class ModifyPlayerSpawnPower
extends Power {
    public final RegistryKey<World> dimension;
    public final float dimensionDistanceMultiplier;
    public final ResourceLocation biomeId;
    public final String spawnStrategy;
    public final Structure<?> structure;
    public final SoundEvent spawnSound;

    public ModifyPlayerSpawnPower(PowerType<?> type, PlayerEntity player, RegistryKey<World> dimension, float dimensionDistanceMultiplier, ResourceLocation biomeId, String spawnStrategy, Structure<?> structure, SoundEvent spawnSound) {
        super(type, player);
        this.dimension = dimension;
        this.dimensionDistanceMultiplier = dimensionDistanceMultiplier;
        this.biomeId = biomeId;
        this.spawnStrategy = spawnStrategy;
        this.structure = structure;
        this.spawnSound = spawnSound;
    }

    @Override
    public void onChosen(boolean isOrbOfOrigin) {
        if (this.player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)this.player;
            Tuple<ServerWorld, BlockPos> spawn = this.getSpawn(false);
            if (spawn != null && !isOrbOfOrigin) {
                Vector3d tpPos = TransportationHelper.func_242379_a((EntityType)EntityType.field_200729_aH, (ICollisionReader)((ICollisionReader)spawn.func_76341_a()), (BlockPos)((BlockPos)spawn.func_76340_b()), (boolean)true);
                if (tpPos != null) {
                    serverPlayer.func_200619_a((ServerWorld)spawn.func_76341_a(), tpPos.field_72450_a, tpPos.field_72448_b, tpPos.field_72449_c, this.player.field_70125_A, this.player.field_70177_z);
                } else {
                    serverPlayer.func_200619_a((ServerWorld)spawn.func_76341_a(), (double)((BlockPos)spawn.func_76340_b()).func_177958_n(), (double)((BlockPos)spawn.func_76340_b()).func_177956_o(), (double)((BlockPos)spawn.func_76340_b()).func_177952_p(), this.player.field_70125_A, this.player.field_70177_z);
                    Origins.LOGGER.warn("Could not spawn player with `ModifySpawnPower` at the desired location.");
                }
            }
        }
    }

    @Override
    public void onRemoved() {
        ServerPlayerEntity serverPlayer;
        if (this.player instanceof ServerPlayerEntity && (serverPlayer = (ServerPlayerEntity)this.player).func_241140_K_() != null && serverPlayer.func_241142_M_()) {
            serverPlayer.func_242111_a(World.field_234918_g_, null, 0.0f, false, false);
        }
    }

    public Tuple<ServerWorld, BlockPos> getSpawn(boolean isSpawnObstructed) {
        if (this.player instanceof ServerPlayerEntity) {
            Vector3d tpPos;
            BlockPos spawnToDimPos;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)this.player;
            ServerWorld world = serverPlayer.func_71121_q().func_73046_m().func_71218_a(this.dimension);
            BlockPos regularSpawn = serverPlayer.func_71121_q().func_73046_m().func_71218_a(World.field_234918_g_).func_241135_u_();
            int center = world.func_234938_ad_() / 2;
            int range = 64;
            switch (this.spawnStrategy) {
                case "center": {
                    spawnToDimPos = new BlockPos(0, center, 0);
                    break;
                }
                case "default": {
                    if (this.dimensionDistanceMultiplier != 0.0f) {
                        spawnToDimPos = new BlockPos((double)((float)regularSpawn.func_177958_n() * this.dimensionDistanceMultiplier), (double)regularSpawn.func_177956_o(), (double)((float)regularSpawn.func_177952_p() * this.dimensionDistanceMultiplier));
                        break;
                    }
                    spawnToDimPos = new BlockPos(regularSpawn.func_177958_n(), regularSpawn.func_177956_o(), regularSpawn.func_177952_p());
                    break;
                }
                default: {
                    Origins.LOGGER.warn("This case does nothing. The game crashes if there is no spawn strategy set");
                    spawnToDimPos = this.dimensionDistanceMultiplier != 0.0f ? new BlockPos((double)((float)regularSpawn.func_177958_n() * this.dimensionDistanceMultiplier), (double)regularSpawn.func_177956_o(), (double)((float)regularSpawn.func_177952_p() * this.dimensionDistanceMultiplier)) : new BlockPos(regularSpawn.func_177958_n(), regularSpawn.func_177956_o(), regularSpawn.func_177952_p());
                }
            }
            if (this.biomeId != null) {
                Optional biomeOptional = world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_241873_b(this.biomeId);
                if (biomeOptional.isPresent()) {
                    BlockPos biomePos = world.func_241116_a_((Biome)biomeOptional.get(), spawnToDimPos, 6400, 8);
                    if (biomePos != null) {
                        spawnToDimPos = biomePos;
                    } else {
                        Origins.LOGGER.warn("Could not find biome \"" + this.biomeId.toString() + "\" in dimension \"" + this.dimension.toString() + "\".");
                    }
                } else {
                    Origins.LOGGER.warn("Biome with ID \"" + this.biomeId.toString() + "\" was not registered.");
                }
            }
            if (this.structure == null) {
                tpPos = this.getValidSpawn(spawnToDimPos, range, world);
            } else {
                BlockPos structurePos = this.getStructureLocation(this.structure, this.dimension);
                if (structurePos == null) {
                    return null;
                }
                ChunkPos structureChunkPos = new ChunkPos(structurePos.func_177958_n() >> 4, structurePos.func_177952_p() >> 4);
                StructureStart structureStart = world.func_241112_a_().func_235013_a_(SectionPos.func_218156_a((ChunkPos)structureChunkPos, (int)0), this.structure, (IStructureReader)world.func_217349_x(structurePos));
                BlockPos structureCenter = new BlockPos(structureStart.func_75071_a().func_215126_f());
                tpPos = this.getValidSpawn(structureCenter, range, world);
            }
            if (tpPos != null) {
                BlockPos.Mutable mutable;
                BlockPos.Mutable spawnLocation = mutable = new BlockPos(tpPos.field_72450_a, tpPos.field_72448_b, tpPos.field_72449_c).func_239590_i_();
                world.func_72863_F().func_217228_a(TicketType.field_219488_a, new ChunkPos((BlockPos)spawnLocation), 11, (Object)Unit.INSTANCE);
                return new Tuple((Object)world, (Object)spawnLocation);
            }
            return null;
        }
        return null;
    }

    private BlockPos getStructureLocation(Structure<?> structure, RegistryKey<World> dimension) {
        BlockPos blockPos = new BlockPos(0, 70, 0);
        ServerWorld serverWorld = this.player.func_184102_h().func_71218_a(dimension);
        BlockPos blockPos2 = serverWorld.func_241117_a_(structure, blockPos, 100, false);
        if (blockPos2 == null) {
            Origins.LOGGER.warn("Could not find '" + structure.func_143025_a() + "' in dimension: " + dimension.func_240901_a_());
            return null;
        }
        return blockPos2;
    }

    private Vector3d getValidSpawn(BlockPos startPos, int range, ServerWorld world) {
        world.func_217353_a(startPos.func_177958_n() >> 4, startPos.func_177952_p() >> 4, ChunkStatus.field_222617_m, true);
        int dx = 1;
        int dz = 0;
        int segmentLength = 1;
        BlockPos.Mutable mutable = startPos.func_239590_i_();
        int center = startPos.func_177956_o();
        int x = startPos.func_177958_n();
        int z = startPos.func_177952_p();
        int segmentPassed = 0;
        int i = 0;
        for (int d = 0; i < world.func_234938_ad_() || d > 0; ++i, --d) {
            for (int coordinateCount = 0; coordinateCount < range; ++coordinateCount) {
                ++segmentPassed;
                mutable.func_223471_o(x += dx);
                mutable.func_223472_q(z += dz);
                mutable.func_185336_p(center + i);
                Vector3d tpPos = TransportationHelper.func_242379_a((EntityType)EntityType.field_200729_aH, (ICollisionReader)world, (BlockPos)mutable, (boolean)true);
                if (tpPos != null && tpPos.func_82617_b() < (double)world.func_234938_ad_()) {
                    return tpPos;
                }
                mutable.func_185336_p(center + d);
                tpPos = TransportationHelper.func_242379_a((EntityType)EntityType.field_200729_aH, (ICollisionReader)world, (BlockPos)mutable, (boolean)true);
                if (tpPos != null && tpPos.func_82617_b() < (double)world.func_234938_ad_()) {
                    return tpPos;
                }
                if (segmentPassed != segmentLength) continue;
                segmentPassed = 0;
                int buffer = dx;
                dx = -dz;
                dz = buffer;
                if (dz != 0) continue;
                ++segmentLength;
            }
        }
        return null;
    }
}

