/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.PowerType;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class Power {
    protected PlayerEntity player;
    protected PowerType<?> type;
    private boolean shouldTick = false;
    private boolean shouldTickWhenInactive = false;
    private List<Predicate<PlayerEntity>> conditions;

    public Power(PowerType<?> type, PlayerEntity player) {
        this.type = type;
        this.player = player;
        this.conditions = new LinkedList<Predicate<PlayerEntity>>();
    }

    public Power addCondition(Predicate<PlayerEntity> condition) {
        this.conditions.add(condition);
        return this;
    }

    protected void setTicking() {
        this.setTicking(false);
    }

    protected void setTicking(boolean evenWhenInactive) {
        this.shouldTick = true;
        this.shouldTickWhenInactive = evenWhenInactive;
    }

    public boolean shouldTick() {
        return this.shouldTick;
    }

    public boolean shouldTickWhenInactive() {
        return this.shouldTickWhenInactive;
    }

    public void tick() {
    }

    public void onChosen(boolean isOrbOfOrigin) {
    }

    public void onLost() {
    }

    public void onAdded() {
    }

    public void onRemoved() {
    }

    public void onRespawn() {
    }

    public boolean isActive() {
        return this.conditions.stream().allMatch(condition -> condition.test(this.player));
    }

    public INBT toTag() {
        return new CompoundNBT();
    }

    public void fromTag(INBT tag) {
    }

    public PowerType<?> getType() {
        return this.type;
    }
}

