/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;

public class PowerTypeRegistry {
    private static HashMap<ResourceLocation, PowerType<?>> idToPower = new HashMap();

    public static <T extends Power> PowerType<T> register(ResourceLocation id, PowerType<T> powerType) {
        if (idToPower.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate power type id tried to register: '" + id.toString() + "'");
        }
        idToPower.put(id, powerType);
        return powerType;
    }

    protected static <T extends Power> PowerType<T> update(ResourceLocation id, PowerType<T> powerType) {
        if (idToPower.containsKey(id)) {
            PowerType<?> old = idToPower.get(id);
            idToPower.remove(id);
        }
        return PowerTypeRegistry.register(id, powerType);
    }

    public static int size() {
        return idToPower.size();
    }

    public static Stream<ResourceLocation> identifiers() {
        return idToPower.keySet().stream();
    }

    public static Iterable<Map.Entry<ResourceLocation, PowerType<?>>> entries() {
        return idToPower.entrySet();
    }

    public static Iterable<PowerType<?>> values() {
        return idToPower.values();
    }

    public static <T extends Power> PowerType<T> get(ResourceLocation id) {
        if (!idToPower.containsKey(id)) {
            throw new IllegalArgumentException("Could not get power type from id '" + id.toString() + "', as it was not registered!");
        }
        return idToPower.get(id);
    }

    public static ResourceLocation getId(PowerType<?> powerType) {
        return powerType.getIdentifier();
    }

    public static boolean contains(ResourceLocation id) {
        return idToPower.containsKey(id);
    }

    public static void clear() {
        idToPower.clear();
    }

    public static void reset() {
        PowerTypeRegistry.clear();
    }
}

