/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.integration.OriginDataLoadedCallback;
import io.github.apace100.origins.integration.OriginEventsArchitectury;
import io.github.apace100.origins.integration.OriginLoadingEvent;
import io.github.apace100.origins.power.CooldownPower;
import io.github.apace100.origins.power.MultiplePowerType;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeReference;
import io.github.apace100.origins.power.PowerTypeRegistry;
import io.github.apace100.origins.power.ToggleNightVisionPower;
import io.github.apace100.origins.power.TogglePower;
import io.github.apace100.origins.power.factory.PowerFactory;
import io.github.apace100.origins.registry.ModRegistriesArchitectury;
import io.github.apace100.origins.util.MultiJsonDataLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class PowerTypes
extends MultiJsonDataLoader {
    public static String CURRENT_NAMESPACE = "";
    public static String CURRENT_PATH = "";
    private static final ResourceLocation MULTIPLE = Origins.identifier("multiple");
    private static final ResourceLocation SIMPLE = Origins.identifier("simple");
    public static final PowerType<Power> WATER_BREATHING = new PowerTypeReference<Power>(new ResourceLocation("origins", "water_breathing"));
    public static final PowerType<Power> CONDUIT_POWER_ON_LAND = new PowerTypeReference<Power>(new ResourceLocation("origins", "conduit_power_on_land"));
    public static final PowerType<Power> AQUA_AFFINITY = new PowerTypeReference<Power>(new ResourceLocation("origins", "aqua_affinity"));
    public static final PowerType<ToggleNightVisionPower> WATER_VISION = new PowerTypeReference<ToggleNightVisionPower>(new ResourceLocation("origins", "water_vision"));
    public static final PowerType<Power> LIKE_WATER = new PowerTypeReference<Power>(new ResourceLocation("origins", "like_water"));
    public static final PowerType<CooldownPower> WEBBING = new PowerTypeReference<CooldownPower>(new ResourceLocation("origins", "webbing"));
    public static final PowerType<TogglePower> CLIMBING = new PowerTypeReference<TogglePower>(new ResourceLocation("origins", "climbing"));
    public static final PowerType<Power> NO_COBWEB_SLOWDOWN = new PowerTypeReference<Power>(new ResourceLocation("origins", "no_cobweb_slowdown"));
    public static final PowerType<Power> MASTER_OF_WEBS_NO_SLOWDOWN = new PowerTypeReference<Power>(new ResourceLocation("origins", "master_of_webs_no_slowdown"));
    public static final PowerType<Power> SLOW_FALLING = new PowerTypeReference<Power>(new ResourceLocation("origins", "slow_falling"));
    public static final PowerType<Power> SCARE_CREEPERS = new PowerTypeReference<Power>(new ResourceLocation("origins", "scare_creepers"));
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final HashMap<ResourceLocation, Integer> loadingPriorities = new HashMap();

    private static void fireLoadingEvent(PowerType<?> powerType) {
        ((OriginLoadingEvent)OriginEventsArchitectury.POWER_TYPE_LOADING.invoker()).onLoad(powerType);
    }

    public PowerTypes() {
        super(GSON, "powers");
    }

    protected void apply(Map<ResourceLocation, List<JsonElement>> loader, IResourceManager manager, IProfiler profiler) {
        PowerTypeRegistry.reset();
        this.loadingPriorities.clear();
        loader.forEach((id, jel) -> jel.forEach(je -> {
            try {
                CURRENT_NAMESPACE = id.func_110624_b();
                CURRENT_PATH = id.func_110623_a();
                JsonObject jo = je.getAsJsonObject();
                ResourceLocation factoryId = ResourceLocation.func_208304_a((String)JSONUtils.func_151200_h((JsonObject)jo, (String)"type"));
                if (MULTIPLE.equals((Object)factoryId)) {
                    LinkedList<ResourceLocation> subPowers = new LinkedList<ResourceLocation>();
                    for (Map.Entry entry : jo.entrySet()) {
                        if (((String)entry.getKey()).equals("type") || ((String)entry.getKey()).equals("loading_priority") || ((String)entry.getKey()).equals("name") || ((String)entry.getKey()).equals("description") || ((String)entry.getKey()).equals("hidden") || ((String)entry.getKey()).equals("condition")) continue;
                        ResourceLocation subId = new ResourceLocation(id + "_" + (String)entry.getKey());
                        try {
                            this.readPower(subId, (JsonElement)entry.getValue(), true);
                            subPowers.add(subId);
                        }
                        catch (Exception e) {
                            Origins.LOGGER.error("There was a problem reading sub-power \"{}\" in power file \"{}\": {}", (Object)subId, id, (Object)e.getMessage());
                        }
                    }
                    MultiplePowerType superPower = (MultiplePowerType)this.readPower((ResourceLocation)id, (JsonElement)je, false, MultiplePowerType::new);
                    superPower.setSubPowers(subPowers);
                } else {
                    this.readPower((ResourceLocation)id, (JsonElement)je, false);
                }
            }
            catch (Exception e) {
                Origins.LOGGER.error("There was a problem reading power file " + id.toString() + " (skipping): " + e.getMessage());
            }
        }));
        this.loadingPriorities.clear();
        CURRENT_NAMESPACE = null;
        CURRENT_PATH = null;
        Origins.LOGGER.info("Finished loading powers from data files. Registry contains " + PowerTypeRegistry.size() + " powers.");
        ((OriginDataLoadedCallback)OriginEventsArchitectury.POWER_TYPES_LOADED.invoker()).onDataLoaded(false);
    }

    private void readPower(ResourceLocation id, JsonElement je, boolean isSubPower) {
        this.readPower(id, je, isSubPower, PowerType::new);
    }

    private PowerType<?> readPower(ResourceLocation id, JsonElement je, boolean isSubPower, BiFunction<ResourceLocation, PowerFactory.Instance, PowerType<?>> powerTypeFactory) {
        Optional<PowerFactory> optionalFactory;
        JsonObject jo = je.getAsJsonObject();
        ResourceLocation factoryId = ResourceLocation.func_208304_a((String)JSONUtils.func_151200_h((JsonObject)jo, (String)"type"));
        if (MULTIPLE.equals((Object)factoryId)) {
            factoryId = SIMPLE;
            if (isSubPower) {
                throw new JsonSyntaxException("Power type \"" + MULTIPLE + "\" may not be used for a sub-power of another \"" + MULTIPLE + "\" power.");
            }
        }
        if (!(optionalFactory = Optional.ofNullable((PowerFactory)((Object)ModRegistriesArchitectury.POWER_FACTORY.get(factoryId)))).isPresent()) {
            throw new JsonSyntaxException("Power type \"" + factoryId + "\" is not defined.");
        }
        PowerFactory.Instance factoryInstance = optionalFactory.get().read(jo);
        PowerType<?> type = powerTypeFactory.apply(id, factoryInstance);
        int priority = JSONUtils.func_151208_a((JsonObject)jo, (String)"loading_priority", (int)0);
        String name = JSONUtils.func_151219_a((JsonObject)jo, (String)"name", (String)"");
        String description = JSONUtils.func_151219_a((JsonObject)jo, (String)"description", (String)"");
        boolean hidden = JSONUtils.func_151209_a((JsonObject)jo, (String)"hidden", (boolean)false);
        if (hidden || isSubPower) {
            type.setHidden();
        }
        type.setTranslationKeys(name, description);
        PowerTypes.fireLoadingEvent(type);
        if (!PowerTypeRegistry.contains(id)) {
            PowerTypeRegistry.register(id, type);
            this.loadingPriorities.put(id, priority);
        } else if (this.loadingPriorities.get(id) < priority) {
            PowerTypeRegistry.update(id, type);
            this.loadingPriorities.put(id, priority);
        }
        return type;
    }

    public ResourceLocation getFabricId() {
        return new ResourceLocation("origins", "powers");
    }
}

