/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public class StartingEquipmentPower
extends Power {
    private final List<ItemStack> itemStacks = new LinkedList<ItemStack>();
    private final HashMap<Integer, ItemStack> slottedStacks = new HashMap();
    private boolean recurrent;

    public StartingEquipmentPower(PowerType<?> type, PlayerEntity player) {
        super(type, player);
    }

    public void setRecurrent(boolean recurrent) {
        this.recurrent = recurrent;
    }

    public void addStack(ItemStack stack) {
        this.itemStacks.add(stack);
    }

    public void addStack(int slot, ItemStack stack) {
        this.slottedStacks.put(slot, stack);
    }

    @Override
    public void onChosen(boolean isOrbOfOrigin) {
        this.giveStacks();
    }

    @Override
    public void onRespawn() {
        if (this.recurrent) {
            this.giveStacks();
        }
    }

    private void giveStacks() {
        this.slottedStacks.forEach((slot, stack) -> {
            Origins.LOGGER.info("Giving player " + stack.toString());
            if (this.player.field_71071_by.func_70301_a(slot.intValue()).func_190926_b()) {
                this.player.field_71071_by.func_70299_a(slot.intValue(), stack);
            } else {
                this.player.func_191521_c(stack);
            }
        });
        this.itemStacks.forEach(is -> {
            ItemStack copy = is.func_77946_l();
            Origins.LOGGER.info("Giving player " + copy.toString());
            this.player.func_191521_c(copy);
        });
    }
}

