/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;

public class StatusEffectPower
extends Power {
    protected final List<EffectInstance> effects = new LinkedList<EffectInstance>();

    public StatusEffectPower(PowerType<?> type, PlayerEntity player) {
        super(type, player);
    }

    public StatusEffectPower(PowerType<?> type, PlayerEntity player, EffectInstance effectInstance) {
        super(type, player);
        this.addEffect(effectInstance);
    }

    public StatusEffectPower addEffect(Effect effect) {
        return this.addEffect(effect, 80);
    }

    public StatusEffectPower addEffect(Effect effect, int lingerDuration) {
        return this.addEffect(effect, lingerDuration, 0);
    }

    public StatusEffectPower addEffect(Effect effect, int lingerDuration, int amplifier) {
        return this.addEffect(new EffectInstance(effect, lingerDuration, amplifier));
    }

    public StatusEffectPower addEffect(EffectInstance instance) {
        this.effects.add(instance);
        return this;
    }

    public void applyEffects() {
        this.effects.stream().map(EffectInstance::new).forEach(arg_0 -> ((PlayerEntity)this.player).func_195064_c(arg_0));
    }
}

